/*
 * Decompiled with CFR 0.152.
 */
package pauker.program;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import pauker.program.Card;
import pauker.program.Lesson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEngine {
    public static final String FRONT_SIDE = "frontSide";
    public static final String REVERSE_SIDE = "reverseSide";
    private static final String OBJECT_ID = "objectId";
    private Analyzer analyzer = new WhitespaceAnalyzer();
    private RAMDirectory ramDirectory = new RAMDirectory();
    private HashMap<String, Card> indexedCards = new HashMap();
    private int searchLimit = 1;

    public SearchEngine() {
        this.init();
    }

    public void init() {
        try {
            IndexWriter indexWriter = new IndexWriter((Directory)this.ramDirectory, this.analyzer, true);
            indexWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.indexedCards.clear();
    }

    public void index(Lesson lesson) {
        try {
            IndexWriter indexWriter = new IndexWriter((Directory)this.ramDirectory, this.analyzer, false);
            for (Card card : lesson.getCards()) {
                this.addCard(indexWriter, card);
            }
            indexWriter.optimize();
            indexWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void index(Card card) {
        this.removeCard(card);
        try {
            IndexWriter indexWriter = new IndexWriter((Directory)this.ramDirectory, this.analyzer, false);
            this.addCard(indexWriter, card);
            indexWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeCard(Card card) {
        String cardID = card.getId();
        try {
            IndexReader reader = IndexReader.open(this.ramDirectory);
            reader.deleteDocuments(new Term(OBJECT_ID, cardID));
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.indexedCards.remove(cardID);
    }

    public void setSearchLimit(int searchLimit) {
        this.searchLimit = searchLimit;
    }

    public List<Card> search(String searchString, String side) {
        ArrayList<Card> similarCards = new ArrayList<Card>();
        try {
            IndexSearcher indexSearcher = new IndexSearcher(this.ramDirectory);
            String[] tokens = searchString.split("\\s");
            StringBuilder stringBuilder = new StringBuilder();
            for (String token : tokens) {
                if (token.length() < this.searchLimit) continue;
                token = QueryParser.escape(token);
                stringBuilder.append(token);
                stringBuilder.append("~");
                stringBuilder.append(" ");
            }
            String queryString = stringBuilder.toString();
            if (queryString.length() > 0) {
                QueryParser queryParser = new QueryParser(side, this.analyzer);
                Query query = queryParser.parse(queryString);
                Hits hits = indexSearcher.search(query);
                int length = hits.length();
                for (int i = 0; i < length; ++i) {
                    Document document = hits.doc(i);
                    String cardID = document.get(OBJECT_ID);
                    Card similarCard = this.indexedCards.get(cardID);
                    similarCards.add(similarCard);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return similarCards;
    }

    private void addCard(IndexWriter indexWriter, Card card) throws IOException {
        String cardID = card.getId();
        String frontSideText = card.getFrontSide().getText();
        String reverseSideText = card.getReverseSide().getText();
        if (cardID != null && frontSideText != null && reverseSideText != null) {
            Document document = new Document();
            document.add(new Field(OBJECT_ID, cardID, Field.Store.YES, Field.Index.UN_TOKENIZED));
            document.add(new Field(FRONT_SIDE, frontSideText, Field.Store.YES, Field.Index.TOKENIZED));
            document.add(new Field(REVERSE_SIDE, reverseSideText, Field.Store.YES, Field.Index.TOKENIZED));
            indexWriter.addDocument(document);
            this.indexedCards.put(cardID, card);
        }
    }
}

