/*
 * Decompiled with CFR 0.152.
 */
package pauker.program;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import pauker.program.Batch;
import pauker.program.Card;
import pauker.program.LongTermBatch;
import pauker.program.SummaryBatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lesson {
    private String description = "";
    private final SummaryBatch summaryBatch;
    private final Batch unlearnedBatch = new Batch(null);
    private final List<Card> ultraShortTermList = new ArrayList<Card>();
    private final List<Card> shortTermList = new ArrayList<Card>();
    private final List<LongTermBatch> longTermBatches = new ArrayList<LongTermBatch>();
    private Random random;

    public Lesson() {
        this.summaryBatch = new SummaryBatch(this);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void addCard(Card card) {
        this.summaryBatch.addCard(card);
        this.unlearnedBatch.addCard(card);
    }

    public SummaryBatch getSummaryBatch() {
        return this.summaryBatch;
    }

    public Batch getUnlearnedBatch() {
        return this.unlearnedBatch;
    }

    public List<Card> getUltraShortTermList() {
        return this.ultraShortTermList;
    }

    public List<Card> getShortTermList() {
        return this.shortTermList;
    }

    public LongTermBatch addLongTermBatch() {
        LongTermBatch newLongTermBatch = new LongTermBatch(this.longTermBatches.size());
        this.longTermBatches.add(newLongTermBatch);
        return newLongTermBatch;
    }

    public LongTermBatch getLongTermBatch(int index) {
        return this.longTermBatches.get(index);
    }

    public int getNumberOfLongTermBatches() {
        return this.longTermBatches.size();
    }

    public List<LongTermBatch> getLongTermBatches() {
        return this.longTermBatches;
    }

    public int getNumberOfCards() {
        int numberOfCards = this.unlearnedBatch.getNumberOfCards();
        numberOfCards += this.ultraShortTermList.size();
        numberOfCards += this.shortTermList.size();
        for (LongTermBatch longTermBatch : this.longTermBatches) {
            numberOfCards += longTermBatch.getNumberOfCards();
        }
        return numberOfCards;
    }

    public List<Card> getCards() {
        ArrayList<Card> cards = new ArrayList<Card>();
        List<Card> unlearnedCards = this.unlearnedBatch.getCards();
        if (unlearnedCards != null) {
            cards.addAll(unlearnedCards);
        }
        for (LongTermBatch longTermBatch : this.longTermBatches) {
            cards.addAll(longTermBatch.getCards());
        }
        return cards;
    }

    public int getNumberOfExpiredCards() {
        int numberOfExpiredCards = 0;
        for (LongTermBatch longTermBatch : this.longTermBatches) {
            numberOfExpiredCards += longTermBatch.getNumberOfExpiredCards();
        }
        return numberOfExpiredCards;
    }

    public Card getRandomExpiredCard() {
        ArrayList<Card> expiredCards = new ArrayList<Card>();
        for (LongTermBatch longTermBatch : this.getLongTermBatches()) {
            for (Card expiredCard : longTermBatch.getExpiredCards()) {
                expiredCards.add(expiredCard);
            }
        }
        int expiredCardCount = expiredCards.size();
        if (expiredCardCount > 0) {
            if (this.random == null) {
                this.random = new Random();
            }
            int randomIndex = this.random.nextInt(expiredCardCount);
            return (Card)expiredCards.get(randomIndex);
        }
        return null;
    }

    public void refreshExpiration() {
        for (LongTermBatch longTermBatch : this.longTermBatches) {
            longTermBatch.refreshExpiration();
        }
    }

    public void trim() {
        for (int i = this.longTermBatches.size() - 1; i >= 0; --i) {
            LongTermBatch longTermBatch = this.longTermBatches.get(i);
            if (longTermBatch.getNumberOfCards() != 0) {
                return;
            }
            this.longTermBatches.remove(i);
        }
    }

    public void reset() {
        for (LongTermBatch longTermBatch : this.longTermBatches) {
            for (Card card : longTermBatch.getCards()) {
                card.setLearned(false);
                this.unlearnedBatch.addCard(card);
            }
        }
        this.longTermBatches.clear();
    }

    public void merge(Lesson otherLesson) {
        List<Card> otherUnlearnedCards = otherLesson.getUnlearnedBatch().getCards();
        this.unlearnedBatch.addCards(otherUnlearnedCards);
        this.summaryBatch.addCards(otherUnlearnedCards);
        int otherNumberOfLongTermBatches = otherLesson.getNumberOfLongTermBatches();
        System.out.println(otherLesson + " contains " + otherNumberOfLongTermBatches + " longterm batches");
        for (int i = 0; i < otherNumberOfLongTermBatches; ++i) {
            if (this.longTermBatches.size() < i + 1) {
                this.addLongTermBatch();
            }
            LongTermBatch batch = this.getLongTermBatch(i);
            LongTermBatch otherBatch = otherLesson.getLongTermBatch(i);
            List<Card> cards = otherBatch.getCards();
            System.out.println("batch " + i + " contains " + cards.size() + " cards");
            batch.addCards(cards);
            this.summaryBatch.addCards(otherUnlearnedCards);
        }
    }

    public void flip() {
        for (Card card : this.getCards()) {
            LongTermBatch longTermBatch;
            int batchNumber;
            if (card.isLearned()) {
                batchNumber = card.getLongTermBatchNumber();
                longTermBatch = this.longTermBatches.get(batchNumber);
                longTermBatch.removeCard(card);
            } else {
                this.unlearnedBatch.removeCard(card);
            }
            card.flip();
            if (card.isLearned()) {
                batchNumber = card.getLongTermBatchNumber();
                for (int size = this.longTermBatches.size(); size < batchNumber + 1; ++size) {
                    this.longTermBatches.add(new LongTermBatch(size));
                }
                longTermBatch = this.longTermBatches.get(batchNumber);
                longTermBatch.addCard(card);
                continue;
            }
            this.unlearnedBatch.addCard(card);
        }
        this.trim();
        this.refreshExpiration();
    }

    public long getNextExpirationTime() {
        boolean noExpiredCards = true;
        for (LongTermBatch longTermBatch : this.longTermBatches) {
            if (longTermBatch.getNumberOfExpiredCards() == 0) continue;
            noExpiredCards = false;
            break;
        }
        long nextExpirationDate = Long.MAX_VALUE;
        if (noExpiredCards) {
            List<Card> cards = this.getCards();
            for (Card card : cards) {
                long cardExpirationTime;
                if (!card.isLearned() || (cardExpirationTime = card.getExpirationTime()) >= nextExpirationDate) continue;
                nextExpirationDate = cardExpirationTime;
            }
        }
        return nextExpirationDate;
    }

    public void forgetCards(Batch batch, int[] indices) {
        if (batch == this.summaryBatch) {
            if (indices.length == batch.getNumberOfCards()) {
                for (LongTermBatch longTermBatch : this.longTermBatches) {
                    for (int i = longTermBatch.getNumberOfCards() - 1; i >= 0; --i) {
                        Card card = longTermBatch.removeCard(i);
                        this.unlearnedBatch.addCard(card);
                    }
                }
            } else {
                for (int i = indices.length - 1; i >= 0; --i) {
                    Card card = batch.getCard(indices[i]);
                    if (!card.isLearned()) continue;
                    int longTermBatchNumber = card.getLongTermBatchNumber();
                    LongTermBatch longTermBatch = this.longTermBatches.get(longTermBatchNumber);
                    longTermBatch.removeCard(card);
                    this.unlearnedBatch.addCard(card);
                }
            }
        } else {
            for (int i = indices.length - 1; i >= 0; --i) {
                Card card = batch.removeCard(indices[i]);
                this.unlearnedBatch.addCard(card);
            }
        }
        this.trim();
    }

    public void instantRepeatCards(Batch batch, int[] indices) {
        if (this.longTermBatches.size() == 0) {
            this.longTermBatches.add(new LongTermBatch(0));
        }
        LongTermBatch firstLongTermBatch = this.longTermBatches.get(0);
        if (batch == this.summaryBatch) {
            if (indices.length == batch.getNumberOfCards()) {
                for (int i = this.unlearnedBatch.getNumberOfCards() - 1; i >= 0; --i) {
                    Card card = this.unlearnedBatch.removeCard(i);
                    firstLongTermBatch.addCard(card);
                    card.expire();
                }
                for (LongTermBatch longTermBatch : this.longTermBatches) {
                    for (int i = longTermBatch.getNumberOfCards() - 1; i >= 0; --i) {
                        Card card = longTermBatch.removeCard(i);
                        firstLongTermBatch.addCard(card);
                        card.expire();
                    }
                }
            } else {
                for (int i = indices.length - 1; i >= 0; --i) {
                    Card card = batch.getCard(indices[i]);
                    if (card.isLearned()) {
                        int longTermBatchNumber = card.getLongTermBatchNumber();
                        if (longTermBatchNumber != 0) {
                            LongTermBatch longTermBatch = this.longTermBatches.get(longTermBatchNumber);
                            longTermBatch.removeCard(card);
                            firstLongTermBatch.addCard(card);
                        }
                    } else {
                        this.unlearnedBatch.removeCard(card);
                        firstLongTermBatch.addCard(card);
                    }
                    card.expire();
                }
            }
        } else if (batch == this.unlearnedBatch) {
            for (int i = indices.length - 1; i >= 0; --i) {
                Card card = batch.removeCard(indices[i]);
                firstLongTermBatch.addCard(card);
                card.expire();
            }
        } else if (batch == firstLongTermBatch) {
            for (int i = indices.length - 1; i >= 0; --i) {
                Card card = batch.getCard(indices[i]);
                card.expire();
            }
        } else {
            for (int i = indices.length - 1; i >= 0; --i) {
                Card card = batch.removeCard(indices[i]);
                firstLongTermBatch.addCard(card);
                card.expire();
            }
        }
        this.trim();
        this.refreshExpiration();
    }
}

