/*
 * Decompiled with CFR 0.152.
 */
package pauker.program;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.util.LinkedList;
import java.util.List;
import pauker.program.Card;
import pauker.program.SearchHit;
import pauker.program.gui.swing.PaukerFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardSide {
    private String text;
    private Font font;
    private Color foregroundColor;
    private Color backgroundColor;
    private ComponentOrientation orientation;
    private boolean repeatByTyping;
    private boolean learned;
    private int longTermBatchNumber;
    private long learnedTimestamp;
    private final List<SearchHit> searchHits;

    public CardSide() {
        this("");
    }

    public CardSide(String text) {
        this.text = text;
        this.searchHits = new LinkedList<SearchHit>();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Font getFont() {
        return this.font;
    }

    public String getFontFamily() {
        return this.font == null ? PaukerFrame.defaultFont.getFamily() : this.font.getFamily();
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public ComponentOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(ComponentOrientation orientation) {
        this.orientation = orientation;
    }

    public int getLongTermBatchNumber() {
        return this.longTermBatchNumber;
    }

    public void setLongTermBatchNumber(int longTermBatchNumber) {
        this.longTermBatchNumber = longTermBatchNumber;
    }

    public long getLearnedTimestamp() {
        return this.learnedTimestamp;
    }

    public void setLearnedTimestamp(long learnedTimestamp) {
        this.learnedTimestamp = learnedTimestamp;
    }

    public boolean isRepeatedByTyping() {
        return this.repeatByTyping;
    }

    public void setRepeatByTyping(boolean repeatByTyping) {
        this.repeatByTyping = repeatByTyping;
    }

    public List<SearchHit> search(Card card, Card.Element cardSide, String pattern, boolean matchCase) {
        this.searchHits.clear();
        if (pattern == null) {
            return this.searchHits;
        }
        String searchText = this.text;
        if (!matchCase) {
            searchText = this.text.toLowerCase();
            pattern = pattern.toLowerCase();
        }
        int index = searchText.indexOf(pattern);
        while (index != -1) {
            this.searchHits.add(new SearchHit(card, cardSide, index));
            index = searchText.indexOf(pattern, index + 1);
        }
        return this.searchHits;
    }

    public List<SearchHit> getSearchHits() {
        return this.searchHits;
    }

    public void cancelSearch() {
        this.searchHits.clear();
    }

    public int getFontSize() {
        if (this.font == null) {
            return PaukerFrame.defaultFont.getSize();
        }
        return this.font.getSize();
    }

    public int getFontStyle() {
        if (this.font == null) {
            return PaukerFrame.defaultFont.getStyle();
        }
        return this.font.getStyle();
    }

    public boolean isLearned() {
        return this.learned;
    }

    public void setLearned(boolean learned) {
        this.learned = learned;
    }
}

