/*
 * Decompiled with CFR 0.152.
 */
package pauker.program;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import pauker.program.Card;
import pauker.program.SearchHit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Batch {
    protected List<Card> cards;
    private static Collator collator = Collator.getInstance();
    private static CardComparator<Card> frontSideComparator = new CardComparator<Card>(){

        @Override
        public int compare(Card card1, Card card2) {
            String frontSideText1 = card1.getFrontSide().getText();
            String frontSideText2 = card2.getFrontSide().getText();
            int result = collator.compare(frontSideText1, frontSideText2);
            if (!1.isAscending()) {
                result = -result;
            }
            return result;
        }
    };
    private static CardComparator<Card> reverseSideComparator = new CardComparator<Card>(){

        @Override
        public int compare(Card card1, Card card2) {
            String reverseSideText1 = card1.getReverseSide().getText();
            String reverseSideText2 = card2.getReverseSide().getText();
            int result = collator.compare(reverseSideText1, reverseSideText2);
            if (!2.isAscending()) {
                result = -result;
            }
            return result;
        }
    };
    private static CardComparator<Card> batchNumberComparator = new CardComparator<Card>(){

        @Override
        public int compare(Card card1, Card card2) {
            int batchNumber1 = card1.getLongTermBatchNumber();
            int batchNumber2 = card2.getLongTermBatchNumber();
            int result = 0;
            if (batchNumber1 < batchNumber2) {
                result = -1;
            } else if (batchNumber1 > batchNumber2) {
                result = 1;
            }
            if (!3.isAscending()) {
                result = -result;
            }
            return result;
        }
    };
    private static CardComparator<Card> learnedDateComparator = new CardComparator<Card>(){

        @Override
        public int compare(Card card1, Card card2) {
            long learnedTime1 = card1.getLearnedTimestamp();
            long learnedTime2 = card2.getLearnedTimestamp();
            int result = 0;
            if (learnedTime1 < learnedTime2) {
                result = -1;
            } else if (learnedTime1 > learnedTime2) {
                result = 1;
            }
            if (!4.isAscending()) {
                result = -result;
            }
            return result;
        }
    };
    private CardComparator<Card> expiredDateComparator = new CardComparator<Card>(){

        @Override
        public int compare(Card card1, Card card2) {
            long expirationTime1 = card1.getExpirationTime();
            long expirationTime2 = card2.getExpirationTime();
            int result = 0;
            if (expirationTime1 < expirationTime2) {
                result = -1;
            } else if (expirationTime1 > expirationTime2) {
                result = 1;
            }
            if (!5.isAscending()) {
                result = -result;
            }
            return result;
        }
    };
    private static CardComparator<Card> repeatingModeComparator = new CardComparator<Card>(){

        @Override
        public int compare(Card card1, Card card2) {
            boolean typing1 = card1.isRepeatedByTyping();
            boolean typing2 = card2.isRepeatedByTyping();
            int result = 0;
            if (!typing1 && typing2) {
                result = -1;
            } else if (typing1 && !typing2) {
                result = 1;
            }
            if (!6.isAscending()) {
                result = -result;
            }
            return result;
        }
    };
    private String searchPattern;
    private Card.Element searchSide;
    private boolean matchCase;
    private List<SearchHit> searchHits;
    private int currentSearchHit;
    private SearchHit savedSearchHit;

    public Batch(List<Card> cards) {
        this.cards = cards == null ? new ArrayList<Card>() : cards;
        this.searchHits = new LinkedList<SearchHit>();
    }

    public int getNumberOfCards() {
        return this.cards.size();
    }

    public Card getCard(int i) {
        return this.cards.get(i);
    }

    public List<Card> getCards() {
        return this.cards;
    }

    public void addCard(Card card) {
        this.cards.add(card);
        card.setLearned(false);
    }

    public void addCard(int index, Card card) {
        this.cards.add(index, card);
        card.setLearned(false);
    }

    public void addCards(List<Card> cards) {
        for (Card card : cards) {
            this.addCard(card);
        }
    }

    public void removeCard(Card card) {
        this.cards.remove(card);
    }

    public Card removeCard(int index) {
        this.savedSearchHit = this.getCurrentSearchHit();
        Card card = this.cards.remove(index);
        this.search(this.searchPattern, this.matchCase, this.searchSide);
        this.restoreSearchHit();
        return card;
    }

    public int indexOf(Card card) {
        return this.cards.indexOf(card);
    }

    public void clear() {
        this.cards.clear();
    }

    public void moveCards(int[] rows, int offset) {
        this.savedSearchHit = this.getCurrentSearchHit();
        if (offset > 0) {
            for (int i = rows.length - 1; i >= 0; --i) {
                this.cards.add(rows[i] + offset, this.cards.remove(rows[i]));
            }
        } else {
            for (int row : rows) {
                this.cards.add(row + offset, this.cards.remove(row));
            }
        }
        this.reloadSearchHits();
        this.restoreSearchHit();
    }

    public int[] shuffle(int[] selectedCards) {
        this.savedSearchHit = this.getCurrentSearchHit();
        Object[] originalSorting = this.cards.toArray();
        Collections.shuffle(this.cards);
        int indices = selectedCards.length;
        int[] newIndices = new int[indices];
        for (int i = 0; i < indices; ++i) {
            int selectedIndex = selectedCards[i];
            Object selectedCard = originalSorting[selectedIndex];
            newIndices[i] = this.cards.indexOf(selectedCard);
        }
        this.reloadSearchHits();
        this.restoreSearchHit();
        return newIndices;
    }

    public int[] sortCards(Card.Element cardElement, boolean ascending) {
        Object[] originalSorting = this.cards.toArray();
        CardComparator<Card> comparator = null;
        switch (cardElement) {
            case FRONT_SIDE: {
                comparator = frontSideComparator;
                break;
            }
            case REVERSE_SIDE: {
                comparator = reverseSideComparator;
                break;
            }
            case BATCH_NUMBER: {
                comparator = batchNumberComparator;
                break;
            }
            case LEARNED_DATE: {
                comparator = learnedDateComparator;
                break;
            }
            case EXPIRED_DATE: {
                comparator = this.expiredDateComparator;
                break;
            }
            case REPEATING_MODE: {
                comparator = repeatingModeComparator;
                break;
            }
            default: {
                System.out.println("WARNING: Batch.sortCards() unknown cardElement " + (Object)((Object)cardElement));
            }
        }
        CardComparator.setAscending(ascending);
        Collections.sort(this.cards, comparator);
        int numberOfCards = this.cards.size();
        int[] newIndices = new int[numberOfCards];
        for (int i = 0; i < numberOfCards; ++i) {
            newIndices[i] = this.cards.indexOf(originalSorting[i]);
        }
        return newIndices;
    }

    public boolean search(String searchPattern, boolean matchCase, Card.Element cardSide) {
        this.searchPattern = searchPattern;
        this.matchCase = matchCase;
        this.searchSide = cardSide;
        if (this.refreshSearchHits()) {
            this.currentSearchHit = 0;
            return true;
        }
        return false;
    }

    public String getSearchPattern() {
        return this.searchPattern;
    }

    public boolean getMatchCase() {
        return this.matchCase;
    }

    public Card.Element getSearchSide() {
        return this.searchSide;
    }

    public SearchHit getCurrentSearchHit() {
        if (this.currentSearchHit > -1 && this.currentSearchHit < this.searchHits.size()) {
            return this.searchHits.get(this.currentSearchHit);
        }
        return null;
    }

    public boolean continueSearch(boolean forward) {
        int numberOfSearchHits = this.searchHits.size();
        if (numberOfSearchHits == 0) {
            return false;
        }
        if (forward) {
            ++this.currentSearchHit;
            if (this.currentSearchHit == numberOfSearchHits) {
                this.currentSearchHit = 0;
            }
        } else {
            --this.currentSearchHit;
            if (this.currentSearchHit == -1) {
                this.currentSearchHit = numberOfSearchHits - 1;
            }
        }
        return true;
    }

    public boolean setSearchCardSide(Card.Element cardSide) {
        if (this.searchPattern == null) {
            return false;
        }
        this.searchSide = cardSide;
        return this.repeatSearch();
    }

    public boolean setMatchCase(boolean matchCase) {
        if (this.searchPattern == null) {
            return false;
        }
        this.matchCase = matchCase;
        return this.repeatSearch();
    }

    public void stopSearching() {
        for (Card card : this.cards) {
            card.stopSearching();
        }
        this.searchPattern = null;
        this.searchHits.clear();
        this.currentSearchHit = -1;
    }

    public boolean repeatSearch() {
        SearchHit tmpObject;
        SearchHit oldSearchHit = null;
        if (this.currentSearchHit > -1 && this.currentSearchHit < this.searchHits.size() && (tmpObject = this.searchHits.get(this.currentSearchHit)) != null) {
            oldSearchHit = tmpObject;
        }
        if (this.refreshSearchHits()) {
            if (oldSearchHit != null) {
                int tmpIndex = this.searchHits.indexOf(oldSearchHit);
                this.currentSearchHit = tmpIndex != -1 ? tmpIndex : 0;
            }
            return true;
        }
        return false;
    }

    private boolean refreshSearchHits() {
        this.searchHits.clear();
        if (this.searchPattern == null || this.searchPattern.length() == 0) {
            return false;
        }
        for (Card card : this.cards) {
            this.searchHits.addAll(card.search(this.searchSide, this.searchPattern, this.matchCase));
        }
        return this.searchHits.size() > 0;
    }

    private boolean reloadSearchHits() {
        this.searchHits.clear();
        for (Card card : this.cards) {
            this.searchHits.addAll(card.getSearchHits());
        }
        return this.searchHits.size() > 0;
    }

    private void restoreSearchHit() {
        if (this.savedSearchHit != null) {
            this.currentSearchHit = this.searchHits.indexOf(this.savedSearchHit);
        }
    }

    private static int compareDates(Date date1, Date date2) {
        if (date1 == null) {
            if (date2 != null) {
                return -1;
            }
        } else {
            if (date2 == null) {
                return 1;
            }
            if (date1.before(date2)) {
                return -1;
            }
            if (date2.before(date1)) {
                return 1;
            }
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class CardComparator<Card>
    implements Comparator<Card> {
        private static boolean ascending = true;

        private CardComparator() {
        }

        public static boolean isAscending() {
            return ascending;
        }

        public static void setAscending(boolean aAscending) {
            ascending = aAscending;
        }
    }
}

