/* ************************************************************************* */
/* SauthPalm.h                                                               */
/* DS Software Authorization Alpha01 API for the HandSpring Visor            */
/* 04/03/2000                                                                */
/*                                                                           */
/* Copyright (C) 2000 Dallas Semiconductor Corporation.                      */
/* All rights Reserved. Printed in U.S.A.                                    */
/* This software is protected by copyright laws of                           */
/* the United States and of foreign countries.                               */
/* This software is furnished under a license agreement and/or a             */
/* nondisclosure agreement and may only be used or copied in accordance      */
/* with the terms of those agreements.                                       */
/* The mere transfer of this software does not imply any licenses            */
/* of trade secrets, proprietary technology, copyrights, patents,            */
/* trademarks, maskwork rights, or any other form of intellectual            */
/* property whatsoever. Dallas Semiconductor retains all ownership rights.   */
/*                                                                           */
/* ************************************************************************* */

#ifndef _SAUTHPALM_H_
#define _SAUTHPALM_H_

#include "ownet.h"

#ifndef OW_UCHAR
typedef unsigned char  uchar;
typedef unsigned short ushort;
typedef unsigned int   uint;
typedef unsigned long  ulong;
#endif

#ifndef SERIAL_DS2480
#define SERIAL_DS2480      0
#endif

#ifndef PARALLEL_DS1481         
#define PARALLEL_DS1481    1
#endif

// DS1413
#ifndef SERIAL_DS1413
#define SERIAL_DS1413      2
#endif

#define DS2480 SERIAL_DS2480
#define DS1410 PARALLEL_DS1481
#define DS1413 SERIAL_DS1413

#define VISOR_EX  1
#define VISOR_INT 2

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
// 
#define PALM_EXTERNAL_DS1481 0
#define PALM_INTERNAL_DS1481 1
////////////////
#define EXT_ENI   0x001
#define EXT_D_CLK 0x002
#define EXT_RES   0x004
#define INT_ENI   0x010
#define INT_D_CLK 0x020
#define INT_RES   0x040
//
#define EXT_O1    0x001
#define INT_O1    0x010
//
#define OUTPUT_DEFAULT     (uchar)0x0ff
#define OUTPUT_ENABLE_ONLY (uchar)(~EXT_ENI | 0x0f)
#define OUTPUT_READ_WRITE1 (uchar)(EXT_D_CLK | EXT_RES)
#define OUTPUT_WRITE0      (uchar)(EXT_RES)
#define OUTPUT_RESET       (uchar)(EXT_D_CLK)
#define OUTPUT_OVERDRIVE   (uchar)(~(EXT_D_CLK | EXT_RES))
#define OUTPUT_OVERDRIVE_ENABLE   (uchar)(~(EXT_D_CLK | EXT_RES | EXT_ENI))
#define OUTPUT_CLOCK_DATA  (uchar)(~(EXT_D_CLK | EXT_ENI))
//
#define far
#define pascal
#define DisableInterrupts()
#define EnableInterrupts()
#define SpinMSec(T) Sleep(T)

//
#define TRUE  1
#define FALSE 0
//
#define RESET OUTPUT_RESET  // Set data lines to 0xFD to perform a reset
#define W0BIT OUTPUT_WRITE0  // Set data lines to 0xFE to send a write 0 
#define RWBIT OUTPUT_READ_WRITE1  // Set data lines to 0xFF to send a write 1 or read 0/1 
//
#define MAX_W 2000
//
////////////////

#ifdef __cplusplus
extern "C" {
#endif

void Sleep(long p_Millis);
// legacy functions
uchar far pascal keyopen(void);
uchar far pascal keyclose(void);
uchar far pascal dowcheck(void);                         
uchar far pascal setup(uchar pn);             
uchar far pascal next(void);
uchar far pascal first(void);
uchar far pascal access(void);
uchar far pascal databyte(uchar br);
uchar far pascal gndtest(void);
uchar far * far pascal romdata(void);
uchar far pascal OverdriveOn(void);
uchar far pascal OverdriveOff(void);
// current functions
uchar SetAdapterType(uchar Type, char *type);
uchar SetAdapterSpeed(ulong speed);
uchar iBDataBlock(uchar *data, int count);
uchar iBDataByte(uchar data);
uchar iBSetup(uchar pn);
uchar iBKeyOpen(void);
uchar iBKeyClose(void);
uchar iBFirst(void);
uchar iBNext(void);
uchar *iBROMData(void);
uchar iBOverdriveOn(void);
uchar iBOverdriveOff(void);
uchar iBStream(uchar *arr,int length);
uchar iBAccess(void);
uchar iBFastAccess(void);
uchar iBStrongAccess(void);
uchar SetAdapter5VTime(uchar time);
uchar Adapter5VPrime(void);
uchar Adapter5VCancel(void);
uchar iBDataBit(uchar bit);
// powerManagment
void AdapterPowerManagement(uchar on);

#ifdef __cplusplus
}
#endif

#endif /* _SAUTHPALM_H_ */

