//---------------------------------------------------------------------------
// Copyright (C) 2000 Dallas Semiconductor Corporation, All Rights Reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY,  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// IN NO EVENT SHALL DALLAS SEMICONDUCTOR BE LIABLE FOR ANY CLAIM, DAMAGES
// OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of Dallas Semiconductor
// shall not be used except as stated in the Dallas Semiconductor
// Branding Policy.
//---------------------------------------------------------------------------
//
// shadebitdemo.c - main function for debit application.
//
// Version: 2.10
//

#include "ownet.h"
#include "shaibutton.h"

extern SMALLINT owFirst(int,SMALLINT,SMALLINT);
extern SMALLINT owAcquire(int,char *);
extern void owRelease(int);
extern long msGettick();


int main(int argc, char** argv)
{
   FileEntry fe = {"COPR",0};
   //timing variables
   long a,b,c,d,e;
   //hold's user's old balance and new balance from acct info
   int oldBalance, newBalance;

   SHACopr copr;
   SHAUser user;

   //could be different ports.
   copr.portnum = 0;
   user.portnum = 0;

   // check for required port name
   if (argc != 2)
   {
      printf("1-Wire Net name required on command line!\n"
             " (example: \"COM1\" (Win32 DS2480),\"/dev/cua0\" "
             "(Linux DS2480),\"1\" (Win32 TMEX)\n");
      exit(1);
   }

   if(!owAcquire(copr.portnum,argv[1]))
   {
      printf("Failed to acquire port.\n");
      exit(1);
   }

#ifdef COPRVM
   // virtual coprocessor
   if(!GetCoprVM(&copr, &fe))
      exit(1);
   printf("Found coprocessor:  EMULATED");
   printf("\n   Provider: %s\n        Aux: %s \n",
      copr.providerName, copr.auxilliaryData);
#else
   // setup file entry struct with the file we are looking for
   //memcpy(fe.Name, "COPR", 4);
   //fe.Ext = 0;

   if(FindCoprSHA(&copr, &fe))
   {
      printf("Found coprocessor:  ");
      PrintSerialNum(copr.devAN);
      printf("\n   Provider: %s\n        Aux: %s \n",
         copr.providerName, copr.auxilliaryData);
   }
   else
   {
      printf("Could not find coprocessor!\n");
      exit(1);
   }
#endif


   puts("\nStarting SHA Debit Application\n");
   puts("\nPlease place user token on the 1-Wire bus.\n");
   puts("If user token is currently on the bus, take it off");
   puts("the bus now and, after a second delay, put it back on.\n");

   memcpy(fe.Name, "DLSM", 4);
   fe.Ext = 102;

   for(;;)
   {
      do
      {
         if(owHasErrors())
            msDelay(10);
         a = msGettick();
      }
      while(!FindUserSHA(&user, &fe, FALSE));// && !key_abort());

      b = msGettick();
      if(VerifyUser(&copr, &user, TRUE))
      {
         c = msGettick();
         if(VerifyData(&copr, &user))
         {
            d = msGettick();
            oldBalance = BytesToInt(user.accountFile.file.balanceBytes, 3);
            if(ExecuteTransaction(&copr, &user, 50, TRUE))
            {
               e = msGettick();
               newBalance = BytesToInt(user.accountFile.file.balanceBytes, 3);
               puts("\n--------------------------------\n");
               puts("Complete Success");
               printf("User token: ");
               PrintSerialNum(user.devAN);
               printf("\noldBalance: $%.2f\n",((double)oldBalance/100));
               printf("newBalance: $%.2f\n",((double)newBalance/100));
               printf(" find time: %ld ms\n",b-a);
               printf(" auth time: %ld ms\n",c-b);
               printf(" verf time: %ld ms\n",d-c);
               printf(" exec time: %ld ms\n",e-d);
               printf("total time: %ld ms\n",e-a);
               puts("\n--------------------------------\n");
            }
            else
            {
               printf("execute transaction failed\n");
               OWERROR_DUMP(stdout);
            }
         }
         else
         {
            printf("verify data failed\n");
            OWERROR_DUMP(stdout);
         }
      }
      else
      {
         printf("verify user failed\n");
         OWERROR_DUMP(stdout);
      }
   }

   owRelease(copr.portnum);

   return TRUE;
}
