/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNPropertiesCommand;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPropSetCommand
extends SVNPropertiesCommand {
    public SVNPropSetCommand() {
        super("propset", new String[]{"pset", "ps"});
    }

    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.FILE);
        options.add(SVNOption.ENCODING);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.REVISION);
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.REVPROP);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    public void run() throws SVNException {
        SVNErrorMessage err;
        String propertyName = this.getSVNEnvironment().popArgument();
        if (propertyName == null) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if (!SVNPropertiesManager.isValidPropertyName((String)propertyName)) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_PROPERTY_NAME, (String)"''{0}'' is not a valid Subversion property name", (Object)propertyName);
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        String encoding = null;
        if (SVNPropertiesManager.propNeedsTranslation((String)propertyName)) {
            encoding = this.getSVNEnvironment().getEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
        } else if (this.getSVNEnvironment().getEncoding() != null) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.UNSUPPORTED_FEATURE, (String)"Bad encoding option: prop value not stored as UTF8");
            SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.CLIENT);
        }
        SVNPropertyValue propertyValue = null;
        if (encoding != null) {
            if (this.getSVNEnvironment().getFileData() != null) {
                String stringValue = null;
                try {
                    stringValue = new String(this.getSVNEnvironment().getFileData(), encoding);
                }
                catch (UnsupportedEncodingException e) {
                    stringValue = new String(this.getSVNEnvironment().getFileData());
                }
                propertyValue = SVNPropertyValue.create((String)stringValue);
            } else {
                propertyValue = SVNPropertyValue.create((String)this.getSVNEnvironment().popArgument());
            }
        } else {
            propertyValue = this.getSVNEnvironment().getFileData() != null ? SVNPropertyValue.create((String)propertyName, (byte[])this.getSVNEnvironment().getFileData()) : SVNPropertyValue.create((String)propertyName, (byte[])this.getSVNEnvironment().popArgument().getBytes());
        }
        List<String> targets = new ArrayList();
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (this.getSVNEnvironment().isRevprop()) {
            if (targets.isEmpty()) {
                targets.add("");
            }
            SVNURL revPropURL = this.getRevpropURL(this.getSVNEnvironment().getStartRevision(), targets);
            this.getSVNEnvironment().getClientManager().getWCClient().doSetRevisionProperty(revPropURL, this.getSVNEnvironment().getStartRevision(), propertyName, propertyValue, this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
        } else if (this.getSVNEnvironment().getStartRevision() != SVNRevision.UNDEFINED) {
            SVNErrorMessage err2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"Cannot specify revision for setting versioned property ''{0}''", (Object)propertyName);
            SVNErrorManager.error((SVNErrorMessage)err2, (SVNLogType)SVNLogType.CLIENT);
        } else {
            SVNDepth depth = this.getSVNEnvironment().getDepth();
            if (depth == SVNDepth.UNKNOWN) {
                depth = SVNDepth.EMPTY;
            }
            if (targets.isEmpty()) {
                SVNErrorMessage err3;
                if (this.getSVNEnvironment().getFileData() == null) {
                    err3 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Explicit target required (''{0}'' interpreted as prop value)", (Object)propertyValue);
                    SVNErrorManager.error((SVNErrorMessage)err3, (SVNLogType)SVNLogType.CLIENT);
                } else {
                    err3 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Explicit target argument required");
                    SVNErrorManager.error((SVNErrorMessage)err3, (SVNLogType)SVNLogType.CLIENT);
                }
            }
            Collection changeLists = this.getSVNEnvironment().getChangelistsCollection();
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            Iterator ts = targets.iterator();
            while (ts.hasNext()) {
                String targetName = (String)ts.next();
                SVNPath target = new SVNPath(targetName);
                if (!target.isFile()) continue;
                boolean success = true;
                try {
                    if (target.isFile()) {
                        client.doSetProperty(target.getFile(), propertyName, propertyValue, this.getSVNEnvironment().isForce(), depth, (ISVNPropertyHandler)this, changeLists);
                    } else {
                        client.setCommitHandler((ISVNCommitHandler)this.getSVNEnvironment());
                        client.doSetProperty(target.getURL(), propertyName, propertyValue, SVNRevision.HEAD, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
                    }
                }
                catch (SVNException e) {
                    success = this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.UNVERSIONED_RESOURCE, SVNErrorCode.ENTRY_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
                }
                this.clearCollectedProperties();
                if (this.getSVNEnvironment().isQuiet()) continue;
                this.checkBooleanProperty(propertyName, propertyValue);
                if (!success) continue;
                String path = SVNCommandUtil.getLocalPath(targetName);
                String message = depth.isRecursive() ? "property ''{0}'' set (recursively) on ''{1}''" : "property ''{0}'' set on ''{1}''";
                message = MessageFormat.format(message, propertyName, path);
                this.getSVNEnvironment().getOut().println(message);
            }
        }
    }

    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
        super.handleProperty(revision, property);
        if (!this.getSVNEnvironment().isQuiet()) {
            String message = "property ''{0}'' set on repository revision {1}";
            message = MessageFormat.format(message, property.getName(), new Long(revision));
            this.getSVNEnvironment().getOut().println(message);
        }
    }
}

