/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitCommand
extends SVNCommand {
    public SVNCommitCommand() {
        super("commit", new String[]{"ci"});
    }

    public boolean isCommitter() {
        return true;
    }

    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.NO_UNLOCK);
        options = SVNOption.addLogMessageOptions(options);
        options.add(SVNOption.CHANGELIST);
        options.add(SVNOption.KEEP_CHANGELISTS);
        return options;
    }

    public void run() throws SVNException {
        SVNDepth depth;
        List targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        Iterator ts = targets.iterator();
        while (ts.hasNext()) {
            String targetName = (String)ts.next();
            SVNPath target = new SVNPath(targetName);
            if (!target.isURL()) continue;
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_BAD_PATH, (String)"Must give local path (not URL) as the target of commit");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        if (targets.isEmpty()) {
            targets.add(".");
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        SVNCommitClient client = this.getSVNEnvironment().getClientManager().getCommitClient();
        ArrayList<File> filesList = new ArrayList<File>();
        Iterator ts2 = targets.iterator();
        while (ts2.hasNext()) {
            String targetName = (String)ts2.next();
            SVNPath target = new SVNPath(targetName);
            if (target.isFile()) {
                filesList.add(target.getFile());
                continue;
            }
            this.getSVNEnvironment().getOut().println("Skipped '" + targetName + "'");
        }
        if (filesList.isEmpty()) {
            return;
        }
        File[] files = filesList.toArray(new File[filesList.size()]);
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        client.setCommitHandler((ISVNCommitHandler)this.getSVNEnvironment());
        boolean keepLocks = this.getSVNEnvironment().getOptions().isKeepLocks();
        SVNCommitInfo info = null;
        try {
            info = client.doCommit(files, keepLocks, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), this.getSVNEnvironment().getChangelists(), this.getSVNEnvironment().isKeepChangelist(), this.getSVNEnvironment().isForce(), depth);
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().getRootErrorMessage();
            if (err.getErrorCode() == SVNErrorCode.UNKNOWN_CHANGELIST) {
                SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
            }
            throw svne;
        }
        if (!this.getSVNEnvironment().isQuiet()) {
            this.getSVNEnvironment().printCommitInfo(info);
        }
    }
}

