/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNTimeUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableOutputStream;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExportEditor;
import org.tmatesoft.svn.core.internal.wc.SVNExternalInfo;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.SVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNReporter;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNUpdateClient
extends SVNBasicClient {
    public SVNUpdateClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNUpdateClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doUpdate(File file, SVNRevision revision, boolean recursive) throws SVNException {
        file = new File(SVNPathUtil.validateFilePath(file.getAbsolutePath()));
        SVNWCAccess wcAccess = this.createWCAccess();
        SVNAdminAreaInfo adminInfo = null;
        try {
            adminInfo = wcAccess.openAnchor(file, true, recursive ? -1 : 0);
            SVNAdminArea anchorArea = adminInfo.getAnchor();
            SVNReporter reporter = new SVNReporter(adminInfo, file, true, recursive, this.getDebugLog());
            SVNEntry entry = anchorArea.getEntry(anchorArea.getThisDirName(), false);
            SVNURL url = entry.getSVNURL();
            if (url == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", anchorArea.getRoot());
                SVNErrorManager.error(err);
            }
            SVNUpdateEditor editor = new SVNUpdateEditor(adminInfo, null, recursive, this.isLeaveConflictsUnresolved());
            SVNRepository repos = this.createRepository(url, true);
            String target = "".equals(adminInfo.getTargetName()) ? null : adminInfo.getTargetName();
            long revNumber = this.getRevisionNumber(revision, repos, file);
            SVNURL reposRoot = repos.getRepositoryRoot(true);
            wcAccess.setRepositoryRoot(file, reposRoot);
            repos.update(revNumber, target, recursive, reporter, SVNCancellableEditor.newInstance(editor, this, this.getDebugLog()));
            if (editor.getTargetRevision() >= 0L) {
                if (recursive && !this.isIgnoreExternals()) {
                    this.handleExternals(adminInfo);
                }
                this.dispatchEvent(SVNEventFactory.createUpdateCompletedEvent(adminInfo, editor.getTargetRevision()));
            }
            long l = editor.getTargetRevision();
            return l;
        }
        finally {
            wcAccess.close();
            this.sleepForTimeStamp();
        }
    }

    public long doSwitch(File file, SVNURL url, SVNRevision revision, boolean recursive) throws SVNException {
        return this.doSwitch(file, url, SVNRevision.UNDEFINED, revision, recursive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doSwitch(File file, SVNURL url, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNURL sourceURL;
            SVNAdminAreaInfo info = wcAccess.openAnchor(file, true, -1);
            SVNReporter reporter = new SVNReporter(info, file, true, recursive, this.getDebugLog());
            SVNAdminArea anchorArea = info.getAnchor();
            SVNEntry entry = anchorArea.getEntry(anchorArea.getThisDirName(), false);
            if (entry == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", anchorArea.getRoot());
                SVNErrorManager.error(err);
            }
            if ((sourceURL = entry.getSVNURL()) == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Directory ''{0}'' has no URL", anchorArea.getRoot());
                SVNErrorManager.error(err);
            }
            SVNRepository repository = this.createRepository(sourceURL, true);
            long revNumber = this.getRevisionNumber(revision, repository, file);
            if (pegRevision != null && pegRevision.isValid()) {
                SVNBasicClient.SVNRepositoryLocation[] locs = this.getLocations(url, null, null, pegRevision, SVNRevision.create(revNumber), SVNRevision.UNDEFINED);
                url = locs[0].getURL();
            }
            SVNUpdateEditor editor = new SVNUpdateEditor(info, url.toString(), recursive, this.isLeaveConflictsUnresolved());
            String target = "".equals(info.getTargetName()) ? null : info.getTargetName();
            repository.update(url, revNumber, target, recursive, reporter, SVNCancellableEditor.newInstance(editor, this, this.getDebugLog()));
            if (editor.getTargetRevision() >= 0L && recursive && !this.isIgnoreExternals()) {
                this.handleExternals(info);
                this.dispatchEvent(SVNEventFactory.createUpdateCompletedEvent(info, editor.getTargetRevision()));
            }
            long l = editor.getTargetRevision();
            return l;
        }
        finally {
            wcAccess.close();
            this.sleepForTimeStamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doCheckout(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, boolean recursive) throws SVNException {
        SVNErrorMessage err;
        if (dstPath == null) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.BAD_FILENAME, "Checkout destination path can not be NULL");
            SVNErrorManager.error(err2);
        }
        SVNRevision sVNRevision = pegRevision = pegRevision == null ? SVNRevision.UNDEFINED : pegRevision;
        if (!revision.isValid() && pegRevision.isValid()) {
            revision = pegRevision;
        }
        if (!revision.isValid()) {
            revision = SVNRevision.HEAD;
        }
        SVNRepository repos = this.createRepository(url, null, pegRevision, revision);
        url = repos.getLocation();
        long revNumber = this.getRevisionNumber(revision, repos, null);
        SVNNodeKind targetNodeKind = repos.checkPath("", revNumber);
        if (targetNodeKind == SVNNodeKind.FILE) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "URL ''{0}'' refers to a file, not a directory", url);
            SVNErrorManager.error(err);
        } else if (targetNodeKind == SVNNodeKind.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn''t exist", url);
            SVNErrorManager.error(err);
        }
        String uuid = repos.getRepositoryUUID(true);
        SVNURL repositoryRoot = repos.getRepositoryRoot(true);
        long result = -1L;
        try {
            SVNWCAccess wcAccess = this.createWCAccess();
            SVNFileType kind = SVNFileType.getType(dstPath);
            if (kind == SVNFileType.NONE) {
                SVNAdminAreaFactory.createVersionedDirectory(dstPath, url, repositoryRoot, uuid, revNumber);
                result = this.doUpdate(dstPath, revision, recursive);
            } else if (kind == SVNFileType.DIRECTORY) {
                int formatVersion = SVNAdminAreaFactory.checkWC(dstPath, true);
                if (formatVersion != 0) {
                    SVNAdminArea adminArea = wcAccess.open(dstPath, false, 0);
                    SVNEntry rootEntry = adminArea.getEntry(adminArea.getThisDirName(), false);
                    wcAccess.closeAdminArea(dstPath);
                    if (rootEntry.getSVNURL() != null && url.equals(rootEntry.getSVNURL())) {
                        result = this.doUpdate(dstPath, revision, recursive);
                    } else {
                        String message = "''{0}'' is already a working copy for a different URL";
                        if (rootEntry.isIncomplete()) {
                            message = message + "; perform update to complete it";
                        }
                        SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, message, dstPath);
                        SVNErrorManager.error(err3);
                    }
                } else {
                    SVNAdminAreaFactory.createVersionedDirectory(dstPath, url, repositoryRoot, uuid, revNumber);
                    result = this.doUpdate(dstPath, revision, recursive);
                }
            } else {
                SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.WC_NODE_KIND_CHANGE, "''{0}'' already exists and is not a directory", dstPath);
                SVNErrorManager.error(err4);
            }
        }
        finally {
            this.sleepForTimeStamp();
        }
        return result;
    }

    public long doExport(SVNURL url, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean force, boolean recursive) throws SVNException {
        SVNRepository repository = this.createRepository(url, null, pegRevision, revision);
        long revisionNumber = this.getRevisionNumber(revision, repository, null);
        long exportedRevision = this.doRemoteExport(repository, revisionNumber, dstPath, eolStyle, force, recursive);
        this.dispatchEvent(SVNEventFactory.createUpdateCompletedEvent(null, exportedRevision));
        return exportedRevision;
    }

    public long doExport(File srcPath, File dstPath, SVNRevision pegRevision, SVNRevision revision, String eolStyle, boolean force, boolean recursive) throws SVNException {
        long exportedRevision = -1L;
        if (revision != SVNRevision.BASE && revision != SVNRevision.WORKING && revision != SVNRevision.COMMITTED && revision != SVNRevision.UNDEFINED) {
            SVNRepository repository = this.createRepository(null, srcPath, pegRevision, revision);
            long revisionNumber = this.getRevisionNumber(revision, repository, srcPath);
            exportedRevision = this.doRemoteExport(repository, revisionNumber, dstPath, eolStyle, force, recursive);
        } else {
            if (revision == SVNRevision.UNDEFINED) {
                revision = SVNRevision.WORKING;
            }
            this.copyVersionedDir(srcPath, dstPath, revision, eolStyle, force, recursive);
        }
        this.dispatchEvent(SVNEventFactory.createUpdateCompletedEvent(null, exportedRevision));
        return exportedRevision;
    }

    private void copyVersionedDir(File from, File to, SVNRevision revision, String eolStyle, boolean force, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        SVNAdminArea adminArea = wcAccess.probeOpen(from, false, 0);
        SVNEntry entry = wcAccess.getEntry(from, false);
        if (entry == null) {
            wcAccess.close();
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control or doesn''t exist", from, 1);
            SVNErrorManager.error(err);
        }
        if (revision == SVNRevision.WORKING && entry.isScheduledForDeletion()) {
            return;
        }
        if (revision != SVNRevision.WORKING && entry.isScheduledForAddition()) {
            return;
        }
        if (entry.isDirectory()) {
            SVNErrorMessage err;
            boolean dirCreated = to.mkdirs();
            if (!to.exists() || to.isFile()) {
                err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot create directory ''{0}''", to);
                SVNErrorManager.error(err);
            }
            if (!dirCreated && to.isDirectory() && !force) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "''{0}'' already exists and will not be owerwritten unless forced", to);
                SVNErrorManager.error(err);
            }
            Iterator ents = adminArea.entries(false);
            while (ents.hasNext()) {
                File childTo;
                SVNEntry childEntry = (SVNEntry)ents.next();
                if (childEntry.isDirectory()) {
                    if (adminArea.getThisDirName().equals(childEntry.getName()) || !recursive) continue;
                    childTo = new File(to, childEntry.getName());
                    File childFrom = new File(from, childEntry.getName());
                    this.copyVersionedDir(childFrom, childTo, revision, eolStyle, force, recursive);
                    continue;
                }
                if (!childEntry.isFile()) continue;
                childTo = new File(to, childEntry.getName());
                this.copyVersionedFile(childTo, adminArea, childEntry.getName(), revision, eolStyle);
            }
        } else if (entry.isFile()) {
            this.copyVersionedFile(to, adminArea, entry.getName(), revision, eolStyle);
        }
        wcAccess.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyVersionedFile(File dstPath, SVNAdminArea adminArea, String fileName, SVNRevision revision, String eol) throws SVNException {
        File srcFile;
        SVNFileType fileType;
        byte[] eols;
        SVNEntry entry = adminArea.getEntry(fileName, false);
        if (revision == SVNRevision.WORKING && entry.isScheduledForDeletion()) {
            return;
        }
        if (revision != SVNRevision.WORKING && entry.isScheduledForAddition()) {
            return;
        }
        boolean modified = false;
        SVNVersionedProperties props = null;
        if (revision != SVNRevision.WORKING) {
            props = adminArea.getBaseProperties(fileName);
        } else {
            props = adminArea.getProperties(fileName);
            modified = adminArea.hasTextModifications(fileName, false);
        }
        boolean special = props.getPropertyValue("svn:special") != null;
        boolean executable = props.getPropertyValue("svn:executable") != null;
        String keywords = props.getPropertyValue("svn:keywords");
        byte[] byArray = eols = eol != null ? SVNTranslator.getEOL(eol) : null;
        if (eols == null) {
            eol = props.getPropertyValue("svn:eol-style");
            eols = SVNTranslator.getWorkingEOL(eol);
        }
        long timestamp = modified && !special ? adminArea.getFile(fileName).lastModified() : SVNTimeUtil.parseDateAsLong(entry.getCommittedDate());
        Map keywordsMap = null;
        if (keywords != null) {
            String author;
            String rev = Long.toString(entry.getCommittedRevision());
            if (modified) {
                author = "(local)";
                rev = rev + "M";
            } else {
                author = entry.getAuthor();
            }
            keywordsMap = SVNTranslator.computeKeywords(keywords, entry.getURL(), author, entry.getCommittedDate(), rev, this.getOptions());
        }
        if ((fileType = SVNFileType.getType(srcFile = revision == SVNRevision.WORKING ? adminArea.getFile(fileName) : adminArea.getBaseFile(fileName, false))) == SVNFileType.SYMLINK && revision == SVNRevision.WORKING) {
            File tmpBaseFile = adminArea.getBaseFile(fileName, true);
            try {
                SVNTranslator.translate(srcFile, tmpBaseFile, eols, keywordsMap, special, false);
                SVNTranslator.translate(tmpBaseFile, dstPath, eols, keywordsMap, special, true);
            }
            finally {
                tmpBaseFile.delete();
            }
        } else {
            SVNTranslator.translate(srcFile, dstPath, eols, keywordsMap, special, true);
        }
        if (executable) {
            SVNFileUtil.setExecutable(dstPath, true);
        }
        if (!special && timestamp > 0L) {
            dstPath.setLastModified(timestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doRemoteExport(SVNRepository repository, final long revNumber, File dstPath, String eolStyle, boolean force, boolean recursive) throws SVNException {
        SVNNodeKind dstKind = repository.checkPath("", revNumber);
        if (dstKind == SVNNodeKind.DIR) {
            SVNExportEditor editor = new SVNExportEditor(this, repository.getLocation().toString(), dstPath, force, eolStyle, this.getOptions());
            repository.update(revNumber, null, recursive, new ISVNReporterBaton(){

                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, revNumber, true);
                    reporter.finishReport();
                }
            }, SVNCancellableEditor.newInstance(editor, this, this.getDebugLog()));
            SVNFileType fileType = SVNFileType.getType(dstPath);
            if (fileType == SVNFileType.NONE) {
                editor.openRoot(revNumber);
            }
            if (!this.isIgnoreExternals() && recursive) {
                Map externals = editor.getCollectedExternals();
                Iterator files = externals.keySet().iterator();
                while (files.hasNext()) {
                    File rootFile = (File)files.next();
                    String propValue = (String)externals.get(rootFile);
                    if (propValue == null) continue;
                    SVNExternalInfo[] infos = SVNAdminAreaInfo.parseExternals("", propValue);
                    for (int i = 0; i < infos.length; ++i) {
                        File targetDir = new File(rootFile, infos[i].getPath());
                        SVNURL srcURL = infos[i].getOldURL();
                        long externalRevNumber = infos[i].getOldRevision();
                        SVNRevision srcRevision = externalRevNumber >= 0L ? SVNRevision.create(externalRevNumber) : SVNRevision.HEAD;
                        String relativePath = targetDir.equals(dstPath) ? "" : targetDir.getAbsolutePath().substring(dstPath.getAbsolutePath().length() + 1);
                        relativePath = relativePath.replace(File.separatorChar, '/');
                        this.dispatchEvent(SVNEventFactory.createUpdateExternalEvent(null, relativePath));
                        try {
                            this.setEventPathPrefix(relativePath);
                            this.doExport(srcURL, targetDir, srcRevision, srcRevision, eolStyle, force, recursive);
                            continue;
                        }
                        catch (SVNException e) {
                            if (e instanceof SVNCancelException) {
                                throw e;
                            }
                            this.dispatchEvent(new SVNEvent(e.getErrorMessage()));
                            continue;
                        }
                        finally {
                            this.setEventPathPrefix(null);
                        }
                    }
                }
            }
        } else if (dstKind == SVNNodeKind.FILE) {
            String url = repository.getLocation().toString();
            if (dstPath.isDirectory()) {
                dstPath = new File(dstPath, SVNEncodingUtil.uriDecode(SVNPathUtil.tail(url)));
            }
            if (dstPath.exists()) {
                if (!force) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' already exists", dstPath);
                    SVNErrorManager.error(err);
                }
            } else {
                dstPath.getParentFile().mkdirs();
            }
            HashMap properties = new HashMap();
            OutputStream os = null;
            File tmpFile = SVNFileUtil.createUniqueFile(dstPath.getParentFile(), ".export", ".tmp");
            try {
                os = SVNFileUtil.openFileForWriting(tmpFile);
                try {
                    repository.getFile("", revNumber, properties, new SVNCancellableOutputStream(os, this));
                }
                finally {
                    SVNFileUtil.closeFile(os);
                }
                if (force && dstPath.exists()) {
                    SVNFileUtil.deleteAll(dstPath, this);
                }
                boolean binary = SVNProperty.isBinaryMimeType((String)properties.get("svn:mime-type"));
                Map keywords = SVNTranslator.computeKeywords((String)properties.get("svn:keywords"), url, (String)properties.get("svn:entry:last-author"), (String)properties.get("svn:entry:committed-date"), (String)properties.get("svn:entry:committed-rev"), this.getOptions());
                byte[] eols = null;
                if ("native".equals(properties.get("svn:eol-style"))) {
                    eols = SVNTranslator.getWorkingEOL(eolStyle != null ? eolStyle : (String)properties.get("svn:eol-style"));
                } else if (properties.containsKey("svn:eol-style")) {
                    eols = SVNTranslator.getWorkingEOL((String)properties.get("svn:eol-style"));
                }
                if (binary) {
                    eols = null;
                    keywords = null;
                }
                SVNTranslator.translate(tmpFile, dstPath, eols, keywords, properties.get("svn:special") != null, true);
            }
            finally {
                SVNFileUtil.deleteFile(tmpFile);
            }
            if (properties.get("svn:executable") != null) {
                SVNFileUtil.setExecutable(dstPath, true);
            }
            this.dispatchEvent(SVNEventFactory.createExportAddedEvent(dstPath.getParentFile(), dstPath, SVNNodeKind.FILE));
        } else {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL ''{0}'' doesn't exist", repository.getLocation());
            SVNErrorManager.error(err);
        }
        return revNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRelocate(File dst, SVNURL oldURL, SVNURL newURL, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNAdminArea adminArea = wcAccess.probeOpen(dst, true, recursive ? -1 : 0);
            String name = dst.equals(adminArea.getRoot()) ? adminArea.getThisDirName() : dst.getName();
            String from = oldURL.toString();
            String to = newURL.toString();
            if (from.endsWith("/")) {
                from = from.substring(0, from.length() - 1);
            }
            if (to.endsWith("/")) {
                to = to.substring(0, to.length() - 1);
            }
            this.doRelocate(adminArea, name, from, to, recursive, new HashMap());
        }
        finally {
            wcAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCanonicalizeURLs(File dst, boolean omitDefaultPort, boolean recursive) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            SVNAdminAreaInfo adminAreaInfo = wcAccess.openAnchor(dst, true, recursive ? -1 : 0);
            SVNAdminArea target = adminAreaInfo.getTarget();
            SVNEntry entry = wcAccess.getEntry(dst, false);
            String name = target.getThisDirName();
            if (entry != null && entry.isFile()) {
                name = entry.getName();
            }
            this.doCanonicalizeURLs(adminAreaInfo, target, name, omitDefaultPort, recursive);
            if (recursive && !this.isIgnoreExternals()) {
                Iterator externals = adminAreaInfo.externals();
                while (externals.hasNext()) {
                    SVNExternalInfo info = (SVNExternalInfo)externals.next();
                    try {
                        this.doCanonicalizeURLs(info.getFile(), omitDefaultPort, true);
                    }
                    catch (SVNCancelException e) {
                        throw e;
                    }
                    catch (SVNException e) {
                        this.getDebugLog().info(e);
                    }
                }
            }
        }
        finally {
            wcAccess.close();
        }
    }

    private void doCanonicalizeURLs(SVNAdminAreaInfo adminAreaInfo, SVNAdminArea adminArea, String name, boolean omitDefaultPort, boolean recursive) throws SVNException {
        boolean save = false;
        this.checkCancelled();
        if (!adminArea.getThisDirName().equals(name)) {
            SVNEntry entry = adminArea.getEntry(name, true);
            save = SVNUpdateClient.canonicalizeEntry(entry, omitDefaultPort);
            adminArea.getWCProperties(name).setPropertyValue("svn:wc:ra_dav:version-url", null);
            if (save) {
                adminArea.saveEntries(false);
            }
            return;
        }
        if (!this.isIgnoreExternals()) {
            String externalsValue = adminArea.getProperties(adminArea.getThisDirName()).getPropertyValue("svn:externals");
            adminAreaInfo.addExternals(adminArea, externalsValue);
            if (externalsValue != null) {
                externalsValue = SVNUpdateClient.canonicalizeExtenrals(externalsValue, omitDefaultPort);
                adminArea.getProperties(adminArea.getThisDirName()).setPropertyValue("svn:externals", externalsValue);
            }
        }
        SVNEntry rootEntry = adminArea.getEntry(adminArea.getThisDirName(), true);
        save = SVNUpdateClient.canonicalizeEntry(rootEntry, omitDefaultPort);
        adminArea.getWCProperties(adminArea.getThisDirName()).setPropertyValue("svn:wc:ra_dav:version-url", null);
        Iterator ents = adminArea.entries(true);
        while (ents.hasNext()) {
            SVNAdminArea childArea;
            SVNEntry entry = (SVNEntry)ents.next();
            if (adminArea.getThisDirName().equals(entry.getName())) continue;
            this.checkCancelled();
            if (recursive && entry.isDirectory() && (entry.isScheduledForAddition() || !entry.isDeleted()) && !entry.isAbsent() && (childArea = adminArea.getWCAccess().retrieve(adminArea.getFile(entry.getName()))) != null) {
                this.doCanonicalizeURLs(adminAreaInfo, childArea, "", omitDefaultPort, recursive);
            }
            save |= SVNUpdateClient.canonicalizeEntry(entry, omitDefaultPort);
            SVNVersionedProperties properties = adminArea.getWCProperties(entry.getName());
            if (properties == null) continue;
            properties.setPropertyValue("svn:wc:ra_dav:version-url", null);
        }
        if (save) {
            adminArea.saveEntries(true);
        }
    }

    private static String canonicalizeExtenrals(String externals, boolean omitDefaultPort) throws SVNException {
        if (externals == null) {
            return null;
        }
        StringBuffer canonicalized = new StringBuffer();
        StringTokenizer lines = new StringTokenizer(externals, "\r\n", true);
        while (lines.hasMoreTokens()) {
            SVNURL canonicalURL;
            String line = lines.nextToken();
            if (line.trim().length() == 0 || line.trim().startsWith("#") || line.indexOf(13) >= 0 || line.indexOf(10) >= 0) {
                canonicalized.append(line);
                continue;
            }
            String[] tokens = line.split("[ \t]");
            int index = tokens.length - 1;
            SVNURL url = null;
            if (index >= 1) {
                try {
                    url = SVNURL.parseURIEncoded(tokens[index]);
                }
                catch (SVNException e) {
                    url = null;
                }
            }
            if ((canonicalURL = SVNUpdateClient.canonicalizeURL(url, omitDefaultPort)) == null) {
                canonicalized.append(line);
                continue;
            }
            canonicalized.append(tokens[0]);
            canonicalized.append(' ');
            if (index == 2) {
                canonicalized.append(tokens[1]);
                canonicalized.append(' ');
            }
            canonicalized.append(canonicalURL.toString());
        }
        return canonicalized.toString();
    }

    private static boolean canonicalizeEntry(SVNEntry entry, boolean omitDefaultPort) throws SVNException {
        SVNURL copyFrom;
        SVNURL url;
        boolean updated = false;
        SVNURL root = SVNUpdateClient.canonicalizeURL(entry.getRepositoryRootURL(), omitDefaultPort);
        if (root != null) {
            updated |= entry.setRepositoryRootURL(root);
        }
        if ((url = SVNUpdateClient.canonicalizeURL(entry.getSVNURL(), omitDefaultPort)) != null) {
            updated |= entry.setURL(url.toString());
        }
        if ((copyFrom = SVNUpdateClient.canonicalizeURL(entry.getCopyFromSVNURL(), omitDefaultPort)) != null) {
            updated |= entry.setCopyFromURL(copyFrom.toString());
        }
        return updated;
    }

    private static SVNURL canonicalizeURL(SVNURL url, boolean omitDefaultPort) throws SVNException {
        if (url == null || url.getPort() <= 0) {
            return null;
        }
        int defaultPort = SVNURL.getDefaultPortNumber(url.getProtocol());
        if (defaultPort <= 0) {
            return null;
        }
        if (omitDefaultPort) {
            if (url.hasPort() && url.getPort() == defaultPort) {
                return SVNURL.create(url.getProtocol(), url.getUserInfo(), url.getHost(), -1, url.getPath(), false);
            }
        } else if (!url.hasPort()) {
            return SVNURL.create(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleExternals(SVNAdminAreaInfo info) throws SVNException {
        Iterator externals = info.externals();
        while (externals.hasNext()) {
            SVNExternalInfo external = (SVNExternalInfo)externals.next();
            if (external.getOldURL() == null && external.getNewURL() == null) continue;
            long revNumber = external.getNewRevision();
            SVNRevision revision = revNumber >= 0L ? SVNRevision.create(revNumber) : this.getExternalRevision(external.getFile(), external.getNewURL());
            this.setEventPathPrefix(external.getPath());
            try {
                if (external.getOldURL() == null) {
                    external.getFile().mkdirs();
                    this.dispatchEvent(SVNEventFactory.createUpdateExternalEvent(info, ""));
                    this.doCheckout(external.getNewURL(), external.getFile(), revision, revision, true);
                    continue;
                }
                if (external.getNewURL() == null) {
                    SVNWCAccess wcAccess = this.createWCAccess();
                    SVNAdminArea area = wcAccess.open(external.getFile(), true, -1);
                    SVNException error = null;
                    try {
                        area.removeFromRevisionControl(area.getThisDirName(), true, false);
                    }
                    catch (SVNException svne) {
                        error = svne;
                    }
                    if (error == null || error.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
                        try {
                            wcAccess.close();
                        }
                        catch (SVNException svne) {
                            SVNException sVNException = error = error == null ? svne : error;
                        }
                    }
                    if (error == null || error.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) continue;
                    throw error;
                }
                this.dispatchEvent(SVNEventFactory.createUpdateExternalEvent(info, ""));
                if (!external.getFile().isDirectory()) {
                    boolean created = external.getFile().mkdirs();
                    try {
                        this.doCheckout(external.getNewURL(), external.getFile(), revision, revision, true);
                        continue;
                    }
                    catch (SVNException e) {
                        if (created && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_ILLEGAL_URL) {
                            SVNFileUtil.deleteAll(external.getFile(), true);
                        }
                        throw e;
                    }
                }
                File[] children = external.getFile().listFiles();
                if (children != null && children.length == 0) {
                    this.doCheckout(external.getNewURL(), external.getFile(), revision, revision, true);
                    continue;
                }
                SVNWCAccess wcAccess = this.createWCAccess();
                SVNAdminArea area = wcAccess.open(external.getFile(), true, 0);
                SVNEntry entry = area.getEntry(area.getThisDirName(), false);
                wcAccess.close();
                String url = entry.getURL();
                if (entry != null && entry.getURL() != null) {
                    if (external.getNewURL().toString().equals(url)) {
                        this.doUpdate(external.getFile(), revision, true);
                        continue;
                    }
                    if (entry.getRepositoryRoot() != null) {
                        if (!SVNPathUtil.isAncestor(entry.getRepositoryRoot(), external.getNewURL().toString())) {
                            SVNRepository repos = this.createRepository(external.getNewURL(), true);
                            SVNURL reposRoot = repos.getRepositoryRoot(true);
                            try {
                                this.doRelocate(external.getFile(), entry.getSVNURL(), reposRoot, true);
                            }
                            catch (SVNException svne) {
                                if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.WC_INVALID_RELOCATION && svne.getErrorMessage().getErrorCode() != SVNErrorCode.CLIENT_INVALID_RELOCATION) {
                                    throw svne;
                                }
                                this.deleteExternal(external);
                                external.getFile().mkdirs();
                                this.doCheckout(external.getNewURL(), external.getFile(), revision, revision, true);
                                this.setEventPathPrefix(null);
                                continue;
                            }
                        }
                        this.doSwitch(external.getFile(), external.getNewURL(), revision, true);
                        continue;
                    }
                }
                this.deleteExternal(external);
                external.getFile().mkdirs();
                this.doCheckout(external.getNewURL(), external.getFile(), revision, revision, true);
                continue;
            }
            catch (SVNException th) {
                if (th instanceof SVNCancelException) {
                    throw th;
                }
                this.getDebugLog().info(th);
                File file = external.getFile();
                SVNEvent event = SVNEventFactory.createSkipEvent(file, file, SVNEventAction.SKIP, SVNEventAction.UPDATE_EXTERNAL, SVNNodeKind.DIR);
                event.setErrorMessage(th.getErrorMessage());
                this.dispatchEvent(event);
                continue;
            }
            finally {
                this.setEventPathPrefix(null);
                continue;
            }
            break;
        }
        return;
    }

    protected SVNRevision getExternalRevision(File file, SVNURL newURL) {
        if (file == null || newURL == null) {
            return SVNRevision.HEAD;
        }
        return SVNRevision.HEAD;
    }

    private void deleteExternal(SVNExternalInfo external) throws SVNException {
        SVNWCAccess wcAccess = this.createWCAccess();
        SVNAdminArea adminArea = wcAccess.open(external.getFile(), true, -1);
        SVNException error = null;
        try {
            adminArea.removeFromRevisionControl(adminArea.getThisDirName(), true, false);
        }
        catch (SVNException svne) {
            this.getDebugLog().info(svne);
            error = svne;
        }
        if (error == null || error.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            wcAccess.close();
        }
        if (error != null && error.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            external.getFile().getParentFile().mkdirs();
            File newLocation = SVNFileUtil.createUniqueFile(external.getFile().getParentFile(), external.getFile().getName(), ".OLD");
            SVNFileUtil.rename(external.getFile(), newLocation);
        } else if (error != null) {
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map validateRelocateTargetURL(SVNURL targetURL, String expectedUUID, Map validatedURLs, boolean isRoot) throws SVNException {
        if (validatedURLs == null) {
            return null;
        }
        Iterator targetURLs = validatedURLs.keySet().iterator();
        while (targetURLs.hasNext()) {
            SVNURL validatedURL = (SVNURL)targetURLs.next();
            if (!targetURL.toString().startsWith(validatedURL.toString())) continue;
            if (isRoot && !targetURL.equals(validatedURL)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "''{0}'' is not the root of the repository", targetURL);
                SVNErrorManager.error(err);
            }
            String validatedUUID = (String)validatedURLs.get(validatedURL);
            if (expectedUUID != null && !expectedUUID.equals(validatedUUID)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "The repository at ''{0}'' has uuid ''{1}'', but the WC has ''{2}''", new Object[]{validatedURL, expectedUUID, validatedUUID});
                SVNErrorManager.error(err);
            }
            return validatedURLs;
        }
        SVNRepository repos = this.createRepository(targetURL, false);
        try {
            SVNURL actualRoot = repos.getRepositoryRoot(true);
            if (isRoot && !targetURL.equals(actualRoot)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "''{0}'' is not the root of the repository", targetURL);
                SVNErrorManager.error(err);
            }
            String actualUUID = repos.getRepositoryUUID(true);
            if (expectedUUID != null && !expectedUUID.equals(actualUUID)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_RELOCATION, "The repository at ''{0}'' has uuid ''{1}'', but the WC has ''{2}''", new Object[]{targetURL, expectedUUID, actualUUID});
                SVNErrorManager.error(err);
            }
            validatedURLs.put(targetURL, actualUUID);
        }
        finally {
            repos.closeSession();
        }
        return validatedURLs;
    }

    private Map relocateEntry(SVNEntry entry, String from, String to, Map validatedURLs) throws SVNException {
        if (entry.getRepositoryRoot() != null) {
            String repos = entry.getRepositoryRoot();
            if (from.length() > repos.length()) {
                String fromPath = from.substring(repos.length());
                if (!to.endsWith(fromPath)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_RELOCATION, "Relocate can only change the repository part of an URL");
                    SVNErrorManager.error(err);
                }
                from = repos;
                to = to.substring(0, to.length() - fromPath.length());
            }
            if (repos.startsWith(from)) {
                entry.setRepositoryRoot(to + repos.substring(from.length()));
                validatedURLs = this.validateRelocateTargetURL(entry.getRepositoryRootURL(), entry.getUUID(), validatedURLs, true);
            }
        }
        if (entry.getURL() != null && entry.getURL().startsWith(from)) {
            entry.setURL(to + entry.getURL().substring(from.length()));
            if (entry.getUUID() != null && validatedURLs != null) {
                validatedURLs = this.validateRelocateTargetURL(entry.getSVNURL(), entry.getUUID(), validatedURLs, false);
            }
        }
        if (entry.getCopyFromURL() != null && entry.getCopyFromURL().startsWith(from)) {
            entry.setCopyFromURL(to + entry.getCopyFromURL().substring(from.length()));
            if (entry.getUUID() != null && validatedURLs != null) {
                validatedURLs = this.validateRelocateTargetURL(entry.getCopyFromSVNURL(), entry.getUUID(), validatedURLs, false);
            }
        }
        return validatedURLs;
    }

    private Map doRelocate(SVNAdminArea adminArea, String name, String from, String to, boolean recursive, Map validatedURLs) throws SVNException {
        SVNEntry entry = adminArea.getEntry(name, true);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND);
            SVNErrorManager.error(err);
        }
        if (entry.isFile()) {
            this.relocateEntry(entry, from, to, validatedURLs);
            SVNPropertiesManager.deleteWCProperties(adminArea, name, false);
            adminArea.saveEntries(false);
            return validatedURLs;
        }
        validatedURLs = this.relocateEntry(entry, from, to, validatedURLs);
        SVNWCAccess wcAccess = adminArea.getWCAccess();
        Iterator entries = adminArea.entries(true);
        while (entries.hasNext()) {
            SVNEntry childEntry = (SVNEntry)entries.next();
            if (adminArea.getThisDirName().equals(childEntry.getName())) continue;
            if (recursive && childEntry.isDirectory() && (childEntry.isScheduledForAddition() || !childEntry.isDeleted()) && !childEntry.isAbsent()) {
                File childDir = adminArea.getFile(childEntry.getName());
                if (wcAccess.isMissing(childDir)) continue;
                SVNAdminArea childArea = wcAccess.retrieve(childDir);
                validatedURLs = this.doRelocate(childArea, childArea.getThisDirName(), from, to, recursive, validatedURLs);
            }
            validatedURLs = this.relocateEntry(childEntry, from, to, validatedURLs);
            SVNPropertiesManager.deleteWCProperties(adminArea, childEntry.getName(), false);
        }
        SVNPropertiesManager.deleteWCProperties(adminArea, "", false);
        adminArea.saveEntries(false);
        return validatedURLs;
    }
}

