/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.svn.ISVNConnector;
import org.tmatesoft.svn.core.internal.io.svn.SVNTunnelConnector;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNMerger;
import org.tmatesoft.svn.core.internal.wc.SVNCompositeConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNConfigFile;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.wc.ISVNMerger;
import org.tmatesoft.svn.core.wc.ISVNMergerFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class DefaultSVNOptions
implements ISVNOptions,
ISVNMergerFactory {
    private static final String MISCELLANY_GROUP = "miscellany";
    private static final String AUTH_GROUP = "auth";
    private static final String AUTOPROPS_GROUP = "auto-props";
    private static final String SVNKIT_GROUP = "svnkit";
    private static final String OLD_SVNKIT_GROUP = "javasvn";
    private static final String USE_COMMIT_TIMES = "use-commit-times";
    private static final String GLOBAL_IGNORES = "global-ignores";
    private static final String ENABLE_AUTO_PROPS = "enable-auto-props";
    private static final String STORE_AUTH_CREDS = "store-auth-creds";
    private static final String KEYWORD_TIMEZONE = "keyword_timezone";
    private static final String KEYWORD_LOCALE = "keyword_locale";
    private static final String DEFAULT_IGNORES = "*.o *.lo *.la #*# .*.rej *.rej .*~ *~ .#* .DS_Store";
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String DEFAULT_LOCALE = Locale.getDefault().toString();
    private static final String DEFAULT_TIMEZONE = TimeZone.getDefault().getID();
    private boolean myIsReadonly;
    private File myConfigDirectory;
    private SVNCompositeConfigFile myConfigFile;
    private ISVNMergerFactory myMergerFactory;
    private String myKeywordLocale = DEFAULT_LOCALE;
    private String myKeywordTimezone = DEFAULT_TIMEZONE;
    private SimpleDateFormat myKeywordDateFormat = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss' 'ZZZZ' ('E', 'dd' 'MMM' 'yyyy')'");

    public DefaultSVNOptions() {
        this(null, true);
    }

    public DefaultSVNOptions(File directory, boolean readOnly) {
        this.myConfigDirectory = directory == null ? DefaultSVNOptions.getDefaultConfigDir() : directory;
        this.myIsReadonly = readOnly;
    }

    public boolean isUseCommitTimes() {
        String value = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, USE_COMMIT_TIMES);
        return DefaultSVNOptions.getBooleanValue(value, false);
    }

    public void setUseCommitTimes(boolean useCommitTimes) {
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, USE_COMMIT_TIMES, useCommitTimes ? YES : NO, !this.myIsReadonly);
    }

    public boolean isUseAutoProperties() {
        String value = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, ENABLE_AUTO_PROPS);
        return DefaultSVNOptions.getBooleanValue(value, false);
    }

    public void setUseAutoProperties(boolean useAutoProperties) {
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, ENABLE_AUTO_PROPS, useAutoProperties ? YES : NO, !this.myIsReadonly);
    }

    public boolean isAuthStorageEnabled() {
        String value = this.getConfigFile().getPropertyValue(AUTH_GROUP, STORE_AUTH_CREDS);
        return DefaultSVNOptions.getBooleanValue(value, true);
    }

    public void setAuthStorageEnabled(boolean storeAuth) {
        this.getConfigFile().setPropertyValue(AUTH_GROUP, STORE_AUTH_CREDS, storeAuth ? YES : NO, !this.myIsReadonly);
    }

    public boolean isIgnored(File file) {
        return file != null && this.isIgnored(file.getName());
    }

    public boolean isIgnored(String name) {
        String[] patterns = this.getIgnorePatterns();
        for (int i = 0; patterns != null && i < patterns.length; ++i) {
            String pattern = patterns[i];
            if (!DefaultSVNOptions.matches(pattern, name)) continue;
            return true;
        }
        return false;
    }

    public String[] getIgnorePatterns() {
        String value = this.getConfigFile().getPropertyValue(MISCELLANY_GROUP, GLOBAL_IGNORES);
        if (value == null) {
            value = DEFAULT_IGNORES;
        }
        ArrayList<String> tokensList = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(value, " \t");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if ("".equals(token)) continue;
            tokensList.add(token);
        }
        return tokensList.toArray(new String[tokensList.size()]);
    }

    public void setIgnorePatterns(String[] patterns) {
        if (patterns == null || patterns.length == 0) {
            this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, GLOBAL_IGNORES, null, !this.myIsReadonly);
            return;
        }
        StringBuffer value = new StringBuffer();
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i];
            if (pattern == null || "".equals(pattern.trim())) continue;
            value.append(pattern);
            value.append(" ");
        }
        String valueStr = value.toString().trim();
        if ("".equals(valueStr)) {
            valueStr = null;
        }
        this.getConfigFile().setPropertyValue(MISCELLANY_GROUP, GLOBAL_IGNORES, valueStr, !this.myIsReadonly);
    }

    public void deleteIgnorePattern(String pattern) {
        if (pattern == null) {
            return;
        }
        String[] patterns = this.getIgnorePatterns();
        ArrayList<String> newPatterns = new ArrayList<String>();
        for (int i = 0; i < patterns.length; ++i) {
            String s = patterns[i];
            if (s.equals(pattern)) continue;
            newPatterns.add(s);
        }
        patterns = newPatterns.toArray(new String[newPatterns.size()]);
        this.setIgnorePatterns(patterns);
    }

    public void addIgnorePattern(String pattern) {
        if (pattern == null) {
            return;
        }
        String[] patterns = this.getIgnorePatterns();
        ArrayList<String> oldPatterns = new ArrayList<String>(Arrays.asList(patterns));
        if (!oldPatterns.contains(pattern)) {
            oldPatterns.add(pattern);
            patterns = oldPatterns.toArray(new String[oldPatterns.size()]);
            this.setIgnorePatterns(patterns);
        }
    }

    public Map getAutoProperties() {
        return this.getConfigFile().getProperties(AUTOPROPS_GROUP);
    }

    public void setAutoProperties(Map autoProperties) {
        String value;
        String pattern;
        autoProperties = autoProperties == null ? Collections.EMPTY_MAP : autoProperties;
        Map existingProperties = this.getAutoProperties();
        Iterator names = existingProperties.keySet().iterator();
        while (names.hasNext()) {
            pattern = (String)names.next();
            value = (String)existingProperties.get(pattern);
            if (value.equals(autoProperties.get(pattern))) continue;
            this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, pattern, null, false);
            names.remove();
        }
        names = autoProperties.keySet().iterator();
        while (names.hasNext()) {
            pattern = (String)names.next();
            value = (String)autoProperties.get(pattern);
            if (value.equals(existingProperties.get(pattern))) continue;
            this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, pattern, value, false);
        }
        if (!this.myIsReadonly) {
            this.getConfigFile().save();
        }
    }

    public void deleteAutoProperty(String pattern) {
        this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, pattern, null, !this.myIsReadonly);
    }

    public void setAutoProperty(String pattern, String properties) {
        this.getConfigFile().setPropertyValue(AUTOPROPS_GROUP, pattern, properties, !this.myIsReadonly);
    }

    public Map applyAutoProperties(File file, Map target) {
        String fileName = file.getName();
        Map map = target = target == null ? new HashMap() : target;
        if (!this.isUseAutoProperties()) {
            return target;
        }
        Map autoProperties = this.getAutoProperties();
        Iterator names = autoProperties.keySet().iterator();
        while (names.hasNext()) {
            String pattern = (String)names.next();
            String value = (String)autoProperties.get(pattern);
            if (value == null || "".equals(value) || !DefaultSVNOptions.matches(pattern, fileName)) continue;
            StringTokenizer tokens = new StringTokenizer(value, ";");
            while (tokens.hasMoreTokens()) {
                String pValue;
                String token = tokens.nextToken().trim();
                int i = token.indexOf(61);
                if (i < 0) {
                    target.put(token, "");
                    continue;
                }
                String name = token.substring(0, i).trim();
                String string = pValue = i == token.length() - 1 ? "" : token.substring(i + 1).trim();
                if ("".equals(name.trim())) continue;
                if (pValue.startsWith("\"") && pValue.endsWith("\"") && pValue.length() > 1) {
                    pValue = pValue.substring(1, pValue.length() - 1);
                }
                target.put(name, pValue);
            }
        }
        return target;
    }

    public ISVNMergerFactory getMergerFactory() {
        if (this.myMergerFactory == null) {
            return this;
        }
        return this.myMergerFactory;
    }

    public void setMergerFactory(ISVNMergerFactory mergerFactory) {
        this.myMergerFactory = mergerFactory;
    }

    public String getPropertyValue(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        String value = this.getConfigFile().getPropertyValue(SVNKIT_GROUP, propertyName);
        if (value == null) {
            value = this.getConfigFile().getPropertyValue(OLD_SVNKIT_GROUP, propertyName);
        }
        return value;
    }

    public void setPropertyValue(String propertyName, String propertyValue) {
        if (propertyName == null || "".equals(propertyName.trim())) {
            return;
        }
        this.getConfigFile().setPropertyValue(SVNKIT_GROUP, propertyName, propertyValue, !this.myIsReadonly);
    }

    private SVNCompositeConfigFile getConfigFile() {
        if (this.myConfigFile == null) {
            SVNConfigFile.createDefaultConfiguration(this.myConfigDirectory);
            SVNConfigFile userConfig = new SVNConfigFile(new File(this.myConfigDirectory, "config"));
            SVNConfigFile systemConfig = new SVNConfigFile(new File(SVNFileUtil.getSystemConfigurationDirectory(), "config"));
            this.myConfigFile = new SVNCompositeConfigFile(systemConfig, userConfig);
        }
        return this.myConfigFile;
    }

    private static File getDefaultConfigDir() {
        return SVNWCUtil.getDefaultConfigurationDirectory();
    }

    private static boolean getBooleanValue(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return YES.equalsIgnoreCase(value = value.trim()) || "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value);
    }

    public static boolean matches(String pattern, String fileName) {
        if (pattern == null || fileName == null) {
            return false;
        }
        Pattern compiled = DefaultSVNOptions.compileNamePatter(pattern);
        if (compiled != null) {
            return compiled.matcher(fileName).matches();
        }
        return false;
    }

    private static Pattern compileNamePatter(String wildcard) {
        if (wildcard == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        block7: for (int i = 0; i < wildcard.length(); ++i) {
            char ch = wildcard.charAt(i);
            switch (ch) {
                case '?': {
                    result.append(".");
                    continue block7;
                }
                case '*': {
                    result.append(".*");
                    continue block7;
                }
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '<': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    result.append("\\");
                }
                default: {
                    result.append(ch);
                }
            }
        }
        try {
            return Pattern.compile(result.toString());
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }

    public ISVNMerger createMerger(byte[] conflictStart, byte[] conflictSeparator, byte[] conflictEnd) {
        return new DefaultSVNMerger(conflictStart, conflictSeparator, conflictEnd);
    }

    public ISVNConnector createTunnelConnector(SVNURL url) {
        String subProtocolName = url.getProtocol().substring("svn+".length());
        if (subProtocolName == null) {
            return null;
        }
        Map tunnels = this.getConfigFile().getProperties("tunnels");
        String tunnel = (String)tunnels.get(subProtocolName);
        if (tunnel == null) {
            return null;
        }
        return new SVNTunnelConnector(subProtocolName, tunnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateFormat getKeywordDateFormat() {
        SimpleDateFormat simpleDateFormat;
        String tzID;
        String localeID = this.getConfigFile().getPropertyValue(SVNKIT_GROUP, KEYWORD_LOCALE);
        if (localeID == null) {
            localeID = DEFAULT_LOCALE;
        }
        if ((tzID = this.getConfigFile().getPropertyValue(SVNKIT_GROUP, KEYWORD_TIMEZONE)) == null) {
            tzID = DEFAULT_TIMEZONE;
        }
        if (!this.myKeywordTimezone.equals(tzID)) {
            TimeZone tz = TimeZone.getTimeZone(tzID);
            this.myKeywordTimezone = tzID;
            simpleDateFormat = this.myKeywordDateFormat;
            synchronized (simpleDateFormat) {
                this.myKeywordDateFormat.setTimeZone(tz);
            }
        }
        if (!this.myKeywordLocale.equals(localeID)) {
            Locale newLocale = DefaultSVNOptions.toLocale(localeID);
            if (newLocale == null) {
                newLocale = Locale.getDefault();
            }
            this.myKeywordLocale = localeID;
            simpleDateFormat = this.myKeywordDateFormat;
            synchronized (simpleDateFormat) {
                this.myKeywordDateFormat.setCalendar(Calendar.getInstance(this.myKeywordDateFormat.getTimeZone(), newLocale));
                this.myKeywordDateFormat.setDateFormatSymbols(new DateFormatSymbols(newLocale));
            }
        }
        return this.myKeywordDateFormat;
    }

    private static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len != 2 && len != 5 && len < 7) {
            return null;
        }
        char ch0 = str.charAt(0);
        char ch1 = str.charAt(1);
        if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
            return null;
        }
        if (len == 2) {
            return new Locale(str, "");
        }
        if (str.charAt(2) != '_') {
            return null;
        }
        char ch3 = str.charAt(3);
        char ch4 = str.charAt(4);
        if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
            return null;
        }
        if (len == 5) {
            return new Locale(str.substring(0, 2), str.substring(3, 5));
        }
        if (str.charAt(5) != '_') {
            return null;
        }
        return new Locale(str.substring(0, 2), str.substring(3, 5), str.substring(6));
    }
}

