/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.DefaultSVNDiffGenerator;
import org.tmatesoft.svn.core.wc.admin.ISVNGNUDiffGenerator;

public class DefaultSVNGNUDiffGenerator
extends DefaultSVNDiffGenerator
implements ISVNGNUDiffGenerator {
    private String myHeader;
    private boolean myIsHeaderWritten;
    private FSRoot myOriginalRoot;
    private String myOriginalPath;
    private FSRoot myNewRoot;
    private String myNewPath;

    public void displayHeader(int type, String path, String copyFromPath, long copyFromRevision, OutputStream result) throws SVNException {
        switch (type) {
            case 0: {
                if (this.myIsHeaderWritten) break;
                path = path.startsWith("/") ? path.substring(1) : path;
                this.myHeader = "Added: " + path;
                this.writeHeader(result);
                break;
            }
            case 1: {
                if (this.myIsHeaderWritten) break;
                path = path.startsWith("/") ? path.substring(1) : path;
                this.myHeader = "Deleted: " + path;
                this.writeHeader(result);
                break;
            }
            case 2: {
                if (this.myIsHeaderWritten) break;
                path = path.startsWith("/") ? path.substring(1) : path;
                this.myHeader = "Modified: " + path;
                this.writeHeader(result);
                break;
            }
            case 3: {
                if (this.myIsHeaderWritten) break;
                path = path.startsWith("/") ? path.substring(1) : path;
                copyFromPath = copyFromPath.startsWith("/") ? copyFromPath.substring(1) : copyFromPath;
                this.myHeader = "Copied: " + path + " (from rev " + copyFromRevision + ", " + copyFromPath + ")";
                this.writeHeader(result);
                break;
            }
            case 4: {
                try {
                    result.write(EOL);
                    break;
                }
                catch (IOException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
                    SVNErrorManager.error(err, e);
                }
            }
        }
    }

    public void displayFileDiff(String path, File file1, File file2, String rev1, String rev2, String mimeType1, String mimeType2, OutputStream result) throws SVNException {
        super.displayFileDiff(path, file1, file2, rev1, rev2, mimeType1, mimeType2, result);
        try {
            result.write(EOL);
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
    }

    protected boolean displayHeader(OutputStream os, String path, boolean deleted) throws IOException {
        if (!this.myIsHeaderWritten) {
            path = path.startsWith("/") ? path.substring(1) : path;
            this.myHeader = "Index: " + path;
            os.write(this.myHeader.getBytes(this.getEncoding()));
            os.write(EOL);
            this.myIsHeaderWritten = true;
        }
        os.write(HEADER_SEPARATOR);
        os.write(EOL);
        return false;
    }

    protected void displayBinary(OutputStream os, String mimeType1, String mimeType2) throws IOException {
        os.write("(Binary files differ)".getBytes(this.getEncoding()));
        os.write(EOL);
    }

    protected void displayHeaderFields(OutputStream os, String path1, String rev1, String path2, String rev2) throws IOException {
        os.write("--- ".getBytes(this.getEncoding()));
        String originalLabel = null;
        String newLabel = null;
        try {
            originalLabel = this.generateLabel(this.myOriginalRoot, this.myOriginalPath);
            newLabel = this.generateLabel(this.myNewRoot, this.myNewPath);
        }
        catch (SVNException svne) {
            throw new IOException(svne.getLocalizedMessage());
        }
        os.write(originalLabel.getBytes(this.getEncoding()));
        os.write(EOL);
        os.write("+++ ".getBytes(this.getEncoding()));
        os.write(newLabel.getBytes(this.getEncoding()));
        os.write(EOL);
    }

    protected void setOriginalFile(FSRoot originalRoot, String originalPath) {
        this.myOriginalRoot = originalRoot;
        this.myOriginalPath = originalPath;
    }

    protected void setNewFile(FSRoot newRoot, String newPath) {
        this.myNewRoot = newRoot;
        this.myNewPath = newPath;
    }

    private String generateLabel(FSRoot root, String path) throws SVNException {
        String date = null;
        String txnName = null;
        long rev = 0L;
        if (root != null) {
            FSFS fsfs = root.getOwner();
            Map props = null;
            if (root instanceof FSRevisionRoot) {
                FSRevisionRoot revisionRoot = (FSRevisionRoot)root;
                rev = revisionRoot.getRevision();
                props = fsfs.getRevisionProperties(rev);
            } else {
                FSTransactionRoot txnRoot = (FSTransactionRoot)root;
                txnName = txnRoot.getTxnID();
                props = fsfs.getTransactionProperties(txnName);
            }
            date = (String)props.get("svn:date");
        }
        String dateString = null;
        if (date != null) {
            int tInd = date.indexOf(84);
            dateString = date.substring(0, tInd) + " " + date.substring(tInd + 1, tInd + 9) + " UTC";
        } else {
            dateString = "                       ";
        }
        if (txnName != null) {
            return path + '\t' + dateString + " (txn " + txnName + ")";
        }
        return path + '\t' + dateString + " (rev " + rev + ")";
    }

    private void writeHeader(OutputStream result) throws SVNException {
        try {
            result.write(this.myHeader.getBytes(this.getEncoding()));
            result.write(EOL);
            this.myIsHeaderWritten = true;
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e);
        }
    }

    protected boolean isHeaderForced(File file1, File file2) {
        return true;
    }

    protected boolean useLocalFileSeparatorChar() {
        return false;
    }
}

