/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;

class HTTPDigestAuthentication
extends HTTPAuthentication {
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String NC = "00000001";
    private String myCnonce;
    private String myQop;

    protected HTTPDigestAuthentication() {
    }

    public void init() throws SVNException {
        String qop = this.getChallengeParameter("qop");
        String selectedQop = null;
        if (qop != null) {
            StringTokenizer tok = new StringTokenizer(qop, ",");
            while (tok.hasMoreTokens() && !"auth".equals(selectedQop = tok.nextToken().trim())) {
            }
        }
        if (selectedQop != null && !"auth".equals(selectedQop)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Digest HTTP auth: ''(0}'' is not supported", selectedQop);
            SVNErrorManager.error(err);
        }
        this.myQop = selectedQop;
        this.myCnonce = HTTPDigestAuthentication.createCnonce();
    }

    public String authenticate() throws SVNException {
        if (this.getUserName() == null || this.getPassword() == null) {
            return null;
        }
        String uname = this.getUserName();
        String digest = this.createDigest(uname, this.getPassword(), "US-ASCII");
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String nonce = this.getParameter("nonce");
        String opaque = this.getParameter("opaque");
        String algorithm = this.getParameter("algorithm", "MD5");
        StringBuffer sb = new StringBuffer();
        sb.append("Digest ");
        sb.append("username=\"" + uname + "\"").append(", realm=\"" + realm + "\"").append(", nonce=\"" + nonce + "\"").append(", uri=\"" + uri + "\"").append(", response=\"" + digest + "\"");
        if (this.myQop != null) {
            sb.append(", qop=\"" + this.myQop + "\"").append(", nc=00000001").append(", cnonce=\"" + this.myCnonce + "\"");
        }
        if (algorithm != null) {
            sb.append(", algorithm=\"" + algorithm + "\"");
        }
        if (opaque != null) {
            sb.append(", opaque=\"" + opaque + "\"");
        }
        return sb.toString();
    }

    public String getAuthenticationScheme() {
        return "Digest";
    }

    private String createDigest(String uname, String pwd, String charset) throws SVNException {
        StringBuffer tmp2;
        MessageDigest md5Helper;
        String digAlg = "MD5";
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String nonce = this.getParameter("nonce");
        String method = this.getParameter("methodname");
        String algorithm = this.getParameter("algorithm", "MD5");
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unsupported algorithm in HTTP Digest authentication: ''{0}''", "MD5");
            SVNErrorManager.error(err);
            return null;
        }
        StringBuffer tmp = new StringBuffer(uname.length() + realm.length() + pwd.length() + 2);
        tmp.append(uname);
        tmp.append(':');
        tmp.append(realm);
        tmp.append(':');
        tmp.append(pwd);
        String a1 = tmp.toString();
        if ("MD5-sess".equals(algorithm)) {
            String tmp22 = HTTPDigestAuthentication.encode(md5Helper.digest(HTTPAuthentication.getBytes(a1, charset)));
            StringBuffer tmp3 = new StringBuffer(tmp22.length() + nonce.length() + this.myCnonce.length() + 2);
            tmp3.append(tmp22);
            tmp3.append(':');
            tmp3.append(nonce);
            tmp3.append(':');
            tmp3.append(this.myCnonce);
            a1 = tmp3.toString();
        }
        String md5a1 = HTTPDigestAuthentication.encode(md5Helper.digest(HTTPAuthentication.getBytes(a1, charset)));
        String a2 = method + ":" + uri;
        String md5a2 = HTTPDigestAuthentication.encode(md5Helper.digest(HTTPAuthentication.getASCIIBytes(a2)));
        if (this.myQop == null) {
            tmp2 = new StringBuffer(md5a1.length() + nonce.length() + md5a2.length());
            tmp2.append(md5a1);
            tmp2.append(':');
            tmp2.append(nonce);
            tmp2.append(':');
            tmp2.append(md5a2);
        } else {
            String qopOption = "auth";
            tmp2 = new StringBuffer(md5a1.length() + nonce.length() + NC.length() + this.myCnonce.length() + qopOption.length() + md5a2.length() + 5);
            tmp2.append(md5a1);
            tmp2.append(':');
            tmp2.append(nonce);
            tmp2.append(':');
            tmp2.append(NC);
            tmp2.append(':');
            tmp2.append(this.myCnonce);
            tmp2.append(':');
            tmp2.append(qopOption);
            tmp2.append(':');
            tmp2.append(md5a2);
        }
        return HTTPDigestAuthentication.encode(md5Helper.digest(HTTPAuthentication.getASCIIBytes(tmp2.toString())));
    }

    private String getParameter(String name) {
        return this.getParameter(name, null);
    }

    private String getParameter(String name, String defaultValue) {
        String value = this.getChallengeParameter(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private static String createCnonce() {
        MessageDigest md5Helper;
        String digAlg = "MD5";
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        String cnonce = Long.toString(System.currentTimeMillis());
        cnonce = HTTPDigestAuthentication.encode(md5Helper.digest(HTTPAuthentication.getASCIIBytes(cnonce)));
        return cnonce;
    }

    private static String encode(byte[] binaryData) {
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        for (int i = 0; i < 16; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }
}

