/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNRevertCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public final void run(PrintStream out, PrintStream err) throws SVNException {
        boolean recursive = this.getCommandLine().hasArgument(SVNArgument.RECURSIVE);
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false));
        SVNWCClient wcClient = this.getClientManager().getWCClient();
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            SVNStatus status;
            File path;
            String absolutePath = this.getCommandLine().getPathAt(i);
            if (("".equals(absolutePath) || ".".equals(absolutePath)) && (path = new File(SVNPathUtil.validateFilePath((String)absolutePath)).getAbsoluteFile()).isDirectory() && (status = this.getClientManager().getStatusClient().doStatus(path, false)).getContentsStatus() == SVNStatusType.STATUS_ADDED) {
                System.err.println("Skipped: " + absolutePath);
                continue;
            }
            wcClient.doRevert(new File(absolutePath), recursive);
        }
    }
}

