/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNResolvedCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        boolean recursive = this.getCommandLine().hasArgument(SVNArgument.RECURSIVE);
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false));
        SVNWCClient wcClient = this.getClientManager().getWCClient();
        boolean error = false;
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            String absolutePath = this.getCommandLine().getPathAt(i);
            try {
                wcClient.doResolve(new File(absolutePath), recursive);
                continue;
            }
            catch (SVNException e) {
                err.println(e.getMessage());
                error = true;
            }
        }
        if (error) {
            System.exit(1);
        }
    }
}

