/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNProplistCommand
extends SVNCommand
implements ISVNPropertyHandler {
    private boolean myIsVerbose;
    private boolean myIsRecursive;
    private PrintStream myOut;
    private boolean myIsRevProp;
    private File myCurrentFile;
    private SVNURL myCurrentURL;
    private long myCurrentRev = -1L;

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public final void run(PrintStream out, PrintStream err) throws SVNException {
        this.myIsRecursive = this.getCommandLine().hasArgument(SVNArgument.RECURSIVE);
        this.myIsRevProp = this.getCommandLine().hasArgument(SVNArgument.REV_PROP);
        this.myIsVerbose = this.getCommandLine().hasArgument(SVNArgument.VERBOSE);
        this.myOut = out;
        this.myIsRecursive &= !this.myIsRevProp;
        SVNRevision revision = SVNRevision.UNDEFINED;
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        SVNWCClient wcClient = this.getClientManager().getWCClient();
        if (this.getCommandLine().hasURLs()) {
            String url = this.getCommandLine().getURL(0);
            if (this.myIsRevProp) {
                wcClient.doGetRevisionProperty(SVNURL.parseURIEncoded((String)url), null, revision, (ISVNPropertyHandler)this);
            } else {
                SVNRevision pegRevision = this.getCommandLine().getPegRevision(0);
                wcClient.doGetProperty(SVNURL.parseURIEncoded((String)url), null, pegRevision, revision, this.myIsRecursive, (ISVNPropertyHandler)this);
            }
        } else if (this.getCommandLine().getPathCount() > 0) {
            String path = this.getCommandLine().getPathAt(0);
            SVNRevision pegRevision = this.getCommandLine().getPathPegRevision(0);
            if (this.myIsRevProp) {
                wcClient.doGetRevisionProperty(new File(path), null, revision, (ISVNPropertyHandler)this);
            } else {
                wcClient.doGetProperty(new File(path), null, pegRevision, revision, this.myIsRecursive, (ISVNPropertyHandler)this);
            }
        }
    }

    public void handleProperty(File path, SVNPropertyData property) throws SVNException {
        if (!path.equals(this.myCurrentFile)) {
            this.myOut.println("Properties on '" + SVNFormatUtil.formatPath((File)path) + "':");
            this.myCurrentFile = path;
        }
        this.myOut.print("  ");
        this.myOut.print(property.getName());
        if (this.myIsVerbose) {
            this.myOut.print(" : " + property.getValue());
        }
        this.myOut.println();
    }

    public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
        if (!url.equals((Object)this.myCurrentURL)) {
            this.myOut.println("Properties on '" + url + "':");
            this.myCurrentURL = url;
        }
        this.myOut.print("  ");
        this.myOut.print(property.getName());
        if (this.myIsVerbose) {
            this.myOut.print(" : " + property.getValue());
        }
        this.myOut.println();
    }

    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
        if (this.myCurrentRev < 0L) {
            this.myCurrentRev = revision;
            this.myOut.println("Unversioned properties on revision " + revision + ":");
        }
        this.myOut.print("  ");
        this.myOut.print(property.getName());
        if (this.myIsVerbose) {
            this.myOut.print(" : " + property.getValue());
        }
        this.myOut.println();
    }
}

