/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookPropgetCommand
extends SVNCommand {
    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(err, "jsvnlook: Repository argument required");
            System.exit(1);
        }
        boolean isRevProp = this.getCommandLine().hasArgument(SVNArgument.REV_PROP);
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        String propertyName = this.getCommandLine().getPathCount() < 2 ? null : this.getCommandLine().getPathAt(1);
        SVNRevision revision = SVNRevision.HEAD;
        SVNLookClient lookClient = this.getClientManager().getLookClient();
        if (this.getCommandLine().hasArgument(SVNArgument.TRANSACTION)) {
            String transactionName = (String)this.getCommandLine().getArgumentValue(SVNArgument.TRANSACTION);
            String path = null;
            String value = null;
            if (isRevProp) {
                value = lookClient.doGetRevisionProperty(reposRoot, propertyName, transactionName);
            } else {
                path = this.getCommandLine().getPathCount() < 3 ? null : SVNPathUtil.canonicalizeAbsPath((String)this.getCommandLine().getPathAt(2));
                value = lookClient.doGetProperty(reposRoot, propertyName, path, transactionName);
            }
            if (value == null) {
                if (path == null) {
                    SVNCommand.println(err, "Property '" + propertyName + "' not found on transaction '" + transactionName + "'");
                    System.exit(1);
                } else {
                    SVNCommand.println(err, "Property '" + propertyName + "' not found on path '" + path + "' in transaction '" + transactionName + "'");
                    System.exit(1);
                }
            }
            SVNCommand.print(out, value);
            return;
        }
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        String path = null;
        String value = null;
        if (isRevProp) {
            value = lookClient.doGetRevisionProperty(reposRoot, propertyName, revision);
        } else {
            path = this.getCommandLine().getPathCount() < 3 ? null : SVNPathUtil.canonicalizeAbsPath((String)this.getCommandLine().getPathAt(2));
            value = lookClient.doGetProperty(reposRoot, propertyName, path, revision);
        }
        if (value == null) {
            long revNum = -1L;
            if (SVNRevision.isValidRevisionNumber((long)revision.getNumber())) {
                revNum = revision.getNumber();
            } else {
                FSFS fsfs = SVNAdminHelper.openRepository((File)reposRoot);
                revNum = SVNAdminHelper.getRevisionNumber((SVNRevision)revision, (long)fsfs.getYoungestRevision(), (FSFS)fsfs);
            }
            if (path == null) {
                SVNCommand.println(err, "Property '" + propertyName + "' not found on revision " + revNum);
                System.exit(1);
            } else {
                SVNCommand.println(err, "Property '" + propertyName + "' not found on path '" + path + "' in revision " + revNum);
                System.exit(1);
            }
        }
        SVNCommand.print(out, value);
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }
}

