/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;

public class SVNCommitCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        this.checkEditorCommand();
        boolean recursive = !this.getCommandLine().hasArgument(SVNArgument.NON_RECURSIVE);
        boolean keepLocks = this.getCommandLine().hasArgument(SVNArgument.NO_UNLOCK);
        String message = this.getCommitMessage();
        File[] localPaths = new File[this.getCommandLine().getPathCount()];
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            SVNCommitCommand.matchTabsInPath(this.getCommandLine().getPathAt(i), err);
            localPaths[i] = new File(this.getCommandLine().getPathAt(i));
        }
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false));
        SVNCommitClient client = this.getClientManager().getCommitClient();
        SVNCommitInfo result = client.doCommit(localPaths, keepLocks, message, false, recursive);
        if (result != SVNCommitInfo.NULL) {
            out.println();
            out.println("Committed revision " + result.getNewRevision() + ".");
        }
        if (result.getErrorMessage() != null && result.getErrorMessage().getErrorCode() == SVNErrorCode.REPOS_POST_COMMIT_HOOK_FAILED) {
            out.println();
            out.println(result.getErrorMessage());
        }
    }

    private void checkEditorCommand() throws SVNException {
        String editorCommand = (String)this.getCommandLine().getArgumentValue(SVNArgument.EDITOR_CMD);
        if (editorCommand == null) {
            return;
        }
        SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_NO_EXTERNAL_EDITOR, (String)("Commit failed. Can''t handle external editor " + editorCommand));
        throw new SVNException(err);
    }
}

