/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNCommandEventProcessor
implements ISVNEventHandler {
    private boolean myIsExternal;
    private boolean myIsChanged;
    private boolean myIsExternalChanged;
    private boolean myIsCheckout;
    private boolean myIsExport;
    private boolean myIsDelta;
    private final PrintStream myPrintStream;
    private PrintStream myErrStream;

    public SVNCommandEventProcessor(PrintStream out, PrintStream err, boolean checkout) {
        this(out, err, checkout, false);
    }

    public SVNCommandEventProcessor(PrintStream out, PrintStream err, boolean checkout, boolean export) {
        this.myPrintStream = out;
        this.myErrStream = err;
        this.myIsCheckout = checkout;
        this.myIsExport = export;
    }

    public void handleEvent(SVNEvent event, double progress) {
        String path;
        String commitPath = null;
        if (event.getAction() == SVNEventAction.COMMIT_ADDED || event.getAction() == SVNEventAction.COMMIT_MODIFIED || event.getAction() == SVNEventAction.COMMIT_DELETED || event.getAction() == SVNEventAction.COMMIT_REPLACED) {
            File root = new File(".");
            File file = event.getFile();
            try {
                if (root.getCanonicalFile().equals(file.getCanonicalFile()) || SVNPathUtil.isChildOf((File)root, (File)file)) {
                    commitPath = SVNFormatUtil.formatPath((File)event.getFile());
                } else {
                    commitPath = event.getPath();
                    if ("".equals(commitPath)) {
                        commitPath = ".";
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (event.getAction() == SVNEventAction.COMMIT_MODIFIED) {
            SVNCommand.println(this.myPrintStream, "Sending        " + commitPath);
        } else if (event.getAction() == SVNEventAction.COMMIT_DELETED) {
            SVNCommand.println(this.myPrintStream, "Deleting       " + commitPath);
        } else if (event.getAction() == SVNEventAction.COMMIT_REPLACED) {
            SVNCommand.println(this.myPrintStream, "Replacing      " + commitPath);
        } else if (event.getAction() == SVNEventAction.COMMIT_DELTA_SENT) {
            if (!this.myIsDelta) {
                SVNCommand.print(this.myPrintStream, "Transmitting file data ");
                this.myIsDelta = true;
            }
            SVNCommand.print(this.myPrintStream, ".");
        } else if (event.getAction() == SVNEventAction.COMMIT_ADDED) {
            String mimeType = event.getMimeType();
            if (SVNProperty.isBinaryMimeType((String)mimeType)) {
                SVNCommand.println(this.myPrintStream, "Adding  (bin)  " + commitPath);
            } else {
                SVNCommand.println(this.myPrintStream, "Adding         " + commitPath);
            }
        } else if (event.getAction() == SVNEventAction.REVERT) {
            SVNCommand.println(this.myPrintStream, "Reverted '" + SVNFormatUtil.formatPath((File)event.getFile()) + "'");
        } else if (event.getAction() == SVNEventAction.FAILED_REVERT) {
            SVNCommand.println(this.myPrintStream, "Failed to revert '" + SVNFormatUtil.formatPath((File)event.getFile()) + "' -- try updating instead.");
        } else if (event.getAction() == SVNEventAction.LOCKED) {
            path = event.getPath();
            if (event.getFile() != null) {
                path = SVNFormatUtil.formatPath((File)event.getFile());
            }
            SVNLock lock = event.getLock();
            SVNCommand.println(this.myPrintStream, "'" + path + "' locked by user '" + lock.getOwner() + "'.");
        } else if (event.getAction() == SVNEventAction.UNLOCKED) {
            path = event.getPath();
            if (event.getFile() != null) {
                path = SVNFormatUtil.formatPath((File)event.getFile());
            }
            SVNCommand.println(this.myPrintStream, "'" + path + "' unlocked.");
        } else if (event.getAction() == SVNEventAction.UNLOCK_FAILED) {
            SVNCommand.println(this.myErrStream, "error: " + event.getErrorMessage());
        } else if (event.getAction() == SVNEventAction.LOCK_FAILED) {
            SVNCommand.println(this.myErrStream, "error: " + event.getErrorMessage());
        } else if (event.getAction() == SVNEventAction.UPDATE_ADD) {
            if (this.myIsExternal) {
                this.myIsExternalChanged = true;
            } else {
                this.myIsChanged = true;
            }
            if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                SVNCommand.println(this.myPrintStream, "C    " + SVNFormatUtil.formatPath((File)event.getFile()));
            } else {
                SVNCommand.println(this.myPrintStream, "A    " + SVNFormatUtil.formatPath((File)event.getFile()));
            }
        } else if (event.getAction() == SVNEventAction.UPDATE_DELETE) {
            if (this.myIsExternal) {
                this.myIsExternalChanged = true;
            } else {
                this.myIsChanged = true;
            }
            SVNCommand.println(this.myPrintStream, "D    " + SVNFormatUtil.formatPath((File)event.getFile()));
        } else if (event.getAction() == SVNEventAction.UPDATE_UPDATE) {
            StringBuffer sb = new StringBuffer();
            if (event.getNodeKind() != SVNNodeKind.DIR) {
                if (event.getContentsStatus() == SVNStatusType.CHANGED) {
                    sb.append("U");
                } else if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                    sb.append("C");
                } else if (event.getContentsStatus() == SVNStatusType.MERGED) {
                    sb.append("G");
                } else {
                    sb.append(" ");
                }
            } else {
                sb.append(' ');
            }
            if (event.getPropertiesStatus() == SVNStatusType.CHANGED) {
                sb.append("U");
            } else if (event.getPropertiesStatus() == SVNStatusType.CONFLICTED) {
                sb.append("C");
            } else if (event.getPropertiesStatus() == SVNStatusType.MERGED) {
                sb.append("G");
            } else {
                sb.append(" ");
            }
            if (sb.toString().trim().length() != 0) {
                if (this.myIsExternal) {
                    this.myIsExternalChanged = true;
                } else {
                    this.myIsChanged = true;
                }
            }
            if (event.getLockStatus() == SVNStatusType.LOCK_UNLOCKED) {
                sb.append("B");
            } else {
                sb.append(" ");
            }
            if (sb.toString().trim().length() > 0) {
                SVNCommand.println(this.myPrintStream, sb.toString() + "  " + SVNFormatUtil.formatPath((File)event.getFile()));
            }
        } else if (event.getAction() == SVNEventAction.UPDATE_COMPLETED) {
            if (!this.myIsExternal) {
                if (this.myIsChanged) {
                    if (this.myIsCheckout) {
                        SVNCommand.println(this.myPrintStream, "Checked out revision " + event.getRevision() + ".");
                    } else if (this.myIsExport) {
                        SVNCommand.println(this.myPrintStream, "Export complete.");
                    } else {
                        SVNCommand.println(this.myPrintStream, "Updated to revision " + event.getRevision() + ".");
                    }
                } else if (this.myIsCheckout) {
                    SVNCommand.println(this.myPrintStream, "Checked out revision " + event.getRevision() + ".");
                } else if (this.myIsExport) {
                    SVNCommand.println(this.myPrintStream, "Export complete.");
                } else {
                    SVNCommand.println(this.myPrintStream, "At revision " + event.getRevision() + ".");
                }
            } else {
                if (this.myIsExternalChanged) {
                    if (this.myIsCheckout) {
                        SVNCommand.println(this.myPrintStream, "Checked out external at revision " + event.getRevision() + ".");
                    } else if (this.myIsExport) {
                        SVNCommand.println(this.myPrintStream, "Export complete.");
                    } else {
                        SVNCommand.println(this.myPrintStream, "Updated external to revision " + event.getRevision() + ".");
                    }
                } else {
                    SVNCommand.println(this.myPrintStream, "External at revision " + event.getRevision() + ".");
                }
                SVNCommand.println(this.myPrintStream);
                this.myIsExternalChanged = false;
                this.myIsExternal = false;
            }
        } else if (event.getAction() == SVNEventAction.UPDATE_EXTERNAL) {
            SVNCommand.println(this.myPrintStream);
            path = event.getPath().replace('/', File.separatorChar);
            if (this.myIsCheckout) {
                SVNCommand.println(this.myPrintStream, "Fetching external item into '" + path + "'");
            } else {
                SVNCommand.println(this.myPrintStream, "Updating external item at '" + path + "'");
            }
            this.myIsExternal = true;
        } else if (event.getAction() == SVNEventAction.STATUS_EXTERNAL) {
            SVNCommand.println(this.myPrintStream);
            path = event.getPath().replace('/', File.separatorChar);
            SVNCommand.println(this.myPrintStream, "Performing status on external item at '" + path + "'");
            this.myIsExternal = true;
        } else if (event.getAction() == SVNEventAction.RESTORE) {
            SVNCommand.println(this.myPrintStream, "Restored '" + SVNFormatUtil.formatPath((File)event.getFile()) + "'");
        } else if (event.getAction() == SVNEventAction.ADD) {
            if (SVNProperty.isBinaryMimeType((String)event.getMimeType())) {
                SVNCommand.println(this.myPrintStream, "A  (bin)  " + SVNFormatUtil.formatPath((File)event.getFile()));
            } else {
                SVNCommand.println(this.myPrintStream, "A         " + SVNFormatUtil.formatPath((File)event.getFile()));
            }
        } else if (event.getAction() == SVNEventAction.DELETE) {
            SVNCommand.println(this.myPrintStream, "D         " + SVNFormatUtil.formatPath((File)event.getFile()));
        } else if (event.getAction() == SVNEventAction.SKIP) {
            SVNCommand.println(this.myPrintStream, "Skipped '" + SVNFormatUtil.formatPath((File)event.getFile()) + "'");
            if (this.myIsExternal && event.getExpectedAction() == SVNEventAction.UPDATE_EXTERNAL) {
                this.myIsExternal = false;
                this.myIsExternalChanged = false;
            }
        } else if (event.getAction() == SVNEventAction.RESOLVED) {
            SVNCommand.println(this.myPrintStream, "Resolved conflicted state of '" + SVNFormatUtil.formatPath((File)event.getFile()) + "'");
        } else if (event.getAction() == SVNEventAction.STATUS_COMPLETED) {
            SVNCommand.println(this.myPrintStream, "Status against revision: " + SVNFormatUtil.formatString((String)Long.toString(event.getRevision()), (int)6, (boolean)false));
        }
    }

    public void checkCancelled() throws SVNCancelException {
    }
}

