/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;

public class SVNAdminRemoveTransactionsCommand
extends SVNCommand
implements ISVNAdminEventHandler {
    private PrintStream myOut;

    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(out, "svnadmin: Repository argument required");
            System.exit(1);
        }
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        LinkedList<String> txnNames = new LinkedList<String>();
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            txnNames.add(this.getCommandLine().getPathAt(i));
        }
        String[] txns = txnNames.toArray(new String[txnNames.size()]);
        this.myOut = out;
        SVNAdminClient adminClient = this.getClientManager().getAdminClient();
        adminClient.setEventHandler((ISVNEventHandler)this);
        adminClient.doRemoveTransactions(reposRoot, txns);
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (event != null && event.getAction() == SVNAdminEventAction.TRANSACTION_REMOVED) {
            String txnName = event.getTxnName();
            SVNCommand.println(this.myOut, "Transaction '" + txnName + "' removed.");
        }
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    public void checkCancelled() throws SVNCancelException {
    }
}

