/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.io.File;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class SVNCommandStatusHandler
implements ISVNStatusHandler {
    private PrintStream myOut;
    private boolean myDetailed;
    private boolean myShowLastCommitted;
    private boolean mySkipUnrecognized;
    private boolean myShowReposLocks;

    public SVNCommandStatusHandler(PrintStream out, boolean detailed, boolean showLastCommitted, boolean skipUnrecognized, boolean showReposLocks) {
        this.myOut = out;
        this.myDetailed = detailed;
        this.myShowLastCommitted = showLastCommitted;
        this.mySkipUnrecognized = skipUnrecognized;
        this.myShowReposLocks = showReposLocks;
    }

    public void handleStatus(SVNStatus status) {
        if (status == null || this.mySkipUnrecognized && status.getURL() == null || status.getContentsStatus() == SVNStatusType.STATUS_NONE && status.getRemoteContentsStatus() == SVNStatusType.STATUS_NONE) {
            return;
        }
        StringBuffer result = new StringBuffer();
        if (!this.myDetailed) {
            result.append(SVNCommandStatusHandler.getStatusChar(status.getContentsStatus()));
            result.append(SVNCommandStatusHandler.getStatusChar(status.getPropertiesStatus()));
            result.append(status.isLocked() ? (char)'L' : ' ');
            result.append(status.isCopied() ? (char)'+' : ' ');
            result.append(status.isSwitched() ? (char)'S' : ' ');
            result.append(status.getLocalLock() != null ? (char)'K' : ' ');
            result.append(" ");
            result.append(SVNFormatUtil.formatPath((File)status.getFile()));
        } else {
            char lockStatus;
            String wcRevision;
            if (status.getURL() == null) {
                wcRevision = "";
            } else if (!status.getRevision().isValid()) {
                wcRevision = " ? ";
            } else if (status.isCopied()) {
                wcRevision = "-";
            } else {
                wcRevision = Long.toString(status.getRevision().getNumber());
                if (status.getKind() == SVNNodeKind.DIR && status.getContentsStatus() == SVNStatusType.STATUS_MISSING) {
                    wcRevision = " ? ";
                }
            }
            char remoteStatus = status.getRemotePropertiesStatus() != SVNStatusType.STATUS_NONE || status.getRemoteContentsStatus() != SVNStatusType.STATUS_NONE ? (char)'*' : ' ';
            if (this.myShowReposLocks) {
                lockStatus = status.getRemoteLock() != null ? (status.getLocalLock() != null ? (status.getLocalLock().getID().equals(status.getRemoteLock().getID()) ? (char)'K' : 'T') : (char)'O') : (status.getLocalLock() != null ? (char)'B' : ' ');
            } else {
                char c = lockStatus = status.getLocalLock() != null ? (char)'K' : ' ';
            }
            if (this.myShowLastCommitted) {
                String commitRevision = "";
                String commitAuthor = "";
                if (status.getURL() != null && status.getCommittedRevision().isValid()) {
                    commitRevision = status.getCommittedRevision().toString();
                } else if (status.getURL() != null) {
                    commitRevision = " ? ";
                }
                if (status.getURL() != null && status.getAuthor() != null) {
                    commitAuthor = status.getAuthor();
                } else if (status.getURL() != null) {
                    commitAuthor = " ? ";
                }
                result.append(SVNCommandStatusHandler.getStatusChar(status.getContentsStatus()));
                result.append(SVNCommandStatusHandler.getStatusChar(status.getPropertiesStatus()));
                result.append(status.isLocked() ? (char)'L' : ' ');
                result.append(status.isCopied() ? (char)'+' : ' ');
                result.append(status.isSwitched() ? (char)'S' : ' ');
                result.append(lockStatus);
                result.append(" ");
                result.append(remoteStatus);
                result.append("   ");
                result.append(SVNCommand.formatString(wcRevision, 6, false));
                result.append("   ");
                result.append(SVNCommand.formatString(commitRevision, 6, false));
                result.append(" ");
                result.append(SVNCommand.formatString(commitAuthor, 12, true));
                result.append(" ");
                result.append(SVNFormatUtil.formatPath((File)status.getFile()));
            } else {
                result.append(SVNCommandStatusHandler.getStatusChar(status.getContentsStatus()));
                result.append(SVNCommandStatusHandler.getStatusChar(status.getPropertiesStatus()));
                result.append(status.isLocked() ? (char)'L' : ' ');
                result.append(status.isCopied() ? (char)'+' : ' ');
                result.append(status.isSwitched() ? (char)'S' : ' ');
                result.append(lockStatus);
                result.append(" ");
                result.append(remoteStatus);
                result.append("   ");
                result.append(SVNCommand.formatString(wcRevision, 6, false));
                result.append("   ");
                result.append(SVNFormatUtil.formatPath((File)status.getFile()));
            }
        }
        this.myOut.println(result.toString());
    }

    private static char getStatusChar(SVNStatusType type) {
        if (type == SVNStatusType.STATUS_NONE) {
            return ' ';
        }
        if (type == SVNStatusType.STATUS_NORMAL) {
            return ' ';
        }
        if (type == SVNStatusType.STATUS_ADDED) {
            return 'A';
        }
        if (type == SVNStatusType.STATUS_MISSING) {
            return '!';
        }
        if (type == SVNStatusType.STATUS_INCOMPLETE) {
            return '!';
        }
        if (type == SVNStatusType.STATUS_DELETED) {
            return 'D';
        }
        if (type == SVNStatusType.STATUS_REPLACED) {
            return 'R';
        }
        if (type == SVNStatusType.STATUS_MODIFIED) {
            return 'M';
        }
        if (type == SVNStatusType.STATUS_CONFLICTED) {
            return 'C';
        }
        if (type == SVNStatusType.STATUS_OBSTRUCTED) {
            return '~';
        }
        if (type == SVNStatusType.STATUS_IGNORED) {
            return 'I';
        }
        if (type == SVNStatusType.STATUS_EXTERNAL) {
            return 'X';
        }
        if (type == SVNStatusType.STATUS_UNVERSIONED) {
            return '?';
        }
        return '?';
    }
}

