/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNCommandLine {
    private Set myUnaryArguments;
    private Map myBinaryArguments;
    private String myCommandName;
    private List myPaths;
    private List myURLs;
    private List myPathURLs;
    private List myPegRevisions;
    private List myPegPathRevisions;

    public SVNCommandLine(String[] commandLine, Set validArguments) throws SVNException {
        this.init(commandLine, validArguments);
    }

    public boolean hasArgument(SVNArgument argument) {
        return this.myBinaryArguments.containsKey(argument) || this.myUnaryArguments.contains(argument);
    }

    public Object getArgumentValue(SVNArgument argument) {
        return this.myBinaryArguments.get(argument);
    }

    public void setArgumentValue(SVNArgument argument, Object value) {
        this.myBinaryArguments.put(argument, value);
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public boolean hasPaths() {
        return !this.myPaths.isEmpty();
    }

    public int getPathCount() {
        return this.myPaths.size();
    }

    public String getPathAt(int index) {
        return (String)this.myPaths.get(index);
    }

    public boolean hasURLs() {
        return !this.myURLs.isEmpty();
    }

    public int getURLCount() {
        return this.myURLs.size();
    }

    public String getURL(int index) {
        return (String)this.myURLs.get(index);
    }

    public SVNRevision getPegRevision(int index) {
        String rev = (String)this.myPegRevisions.get(index);
        return SVNRevision.parse((String)rev);
    }

    public SVNRevision getPathPegRevision(int index) {
        String rev = (String)this.myPegPathRevisions.get(index);
        return SVNRevision.parse((String)rev);
    }

    public void setURLAt(int index, String url) {
        if (index >= this.myURLs.size()) {
            this.myURLs.add(url);
            return;
        }
        if (url != null) {
            this.myURLs.set(index, url);
        } else {
            this.myURLs.remove(index);
        }
    }

    public void setPathAt(int index, String path) {
        if (index >= this.myPaths.size()) {
            this.myPaths.add(path);
            this.myPegPathRevisions.add(SVNRevision.UNDEFINED.toString());
            return;
        }
        if (path != null) {
            this.myPaths.set(index, path);
        } else {
            this.myPaths.remove(index);
            this.myPegPathRevisions.remove(index);
        }
    }

    protected void init(String[] arguments, Set validArguments) throws SVNException {
        this.myUnaryArguments = new HashSet();
        this.myBinaryArguments = new HashMap();
        this.myPaths = new ArrayList();
        this.myURLs = new ArrayList();
        this.myPathURLs = new ArrayList();
        this.myPegRevisions = new ArrayList();
        this.myPegPathRevisions = new ArrayList();
        SVNArgument previousArgument = null;
        String previousArgumentName = null;
        boolean hasPegRevisions = false;
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (previousArgument != null) {
                if (argument.startsWith("--") || argument.startsWith("-") && SVNArgument.LIMIT != previousArgument && SVNArgument.CHANGE != previousArgument) {
                    SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)("argument '" + previousArgumentName + "' requires value"));
                    throw new SVNException(err);
                }
                Object value = previousArgument.parseValue(argument);
                this.myBinaryArguments.put(previousArgument, value);
                previousArgument = null;
                previousArgumentName = null;
                continue;
            }
            if (argument.startsWith("--")) {
                SVNArgument svnArgument = SVNArgument.findArgument(argument, validArguments);
                if (svnArgument != null) {
                    if (svnArgument.hasValue()) {
                        previousArgument = svnArgument;
                        previousArgumentName = argument;
                        continue;
                    }
                    this.myUnaryArguments.add(svnArgument);
                    continue;
                }
                SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)("invalid argument '" + argument + "'"));
                throw new SVNException(err);
            }
            if (argument.startsWith("-")) {
                for (int j = 1; j < argument.length(); ++j) {
                    String name = "-" + argument.charAt(j);
                    SVNArgument svnArgument = SVNArgument.findArgument(name, validArguments);
                    if (svnArgument != null) {
                        if (svnArgument.hasValue()) {
                            if (j + 1 < argument.length()) {
                                String value = argument.substring(j + 1);
                                Object argValue = svnArgument.parseValue(value);
                                this.myBinaryArguments.put(svnArgument, argValue);
                            } else {
                                previousArgument = svnArgument;
                                previousArgumentName = name;
                            }
                            j = argument.length();
                            continue;
                        }
                        this.myUnaryArguments.add(svnArgument);
                        continue;
                    }
                    SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)("invalid argument '" + name + "'"));
                    throw new SVNException(err);
                }
                continue;
            }
            if (this.myCommandName == null) {
                this.myCommandName = argument;
                hasPegRevisions = SVNCommand.hasPegRevision(this.myCommandName);
                continue;
            }
            String pegRevision = SVNRevision.UNDEFINED.toString();
            if (hasPegRevisions) {
                int atIndex = argument.lastIndexOf(64);
                if (atIndex > 0 && atIndex != argument.length() - 1) {
                    pegRevision = argument.substring(argument.lastIndexOf(64) + 1);
                    argument = argument.substring(0, argument.lastIndexOf(64));
                    if (SVNRevision.parse((String)pegRevision) == SVNRevision.UNDEFINED) {
                        SVNErrorMessage msg = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)("Syntax error parsing revision '" + pegRevision + "'"));
                        throw new SVNException(msg);
                    }
                } else if (atIndex > 0 && atIndex == argument.length() - 1) {
                    argument = argument.substring(0, argument.length() - 1);
                }
            }
            this.myPathURLs.add(argument);
            if (argument.indexOf("://") >= 0) {
                this.myURLs.add(argument);
                this.myPegRevisions.add(pegRevision);
                continue;
            }
            this.myPaths.add(argument);
            this.myPegPathRevisions.add(pegRevision);
        }
        if (this.myCommandName == null) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"no command name defined");
            throw new SVNException(err);
        }
        if (this.myPathURLs.isEmpty()) {
            this.myPaths.add(".");
            this.myPegPathRevisions.add(SVNRevision.UNDEFINED.toString());
            this.myPathURLs.add(".");
        }
    }

    public boolean isURL(String url) {
        return url != null && url.indexOf("://") >= 0;
    }

    public boolean isPathURLBefore(String pathURL1, String pathURL2) {
        int index2;
        int index1 = this.myPathURLs.indexOf(pathURL1);
        return index1 < (index2 = this.myPathURLs.indexOf(pathURL2));
    }
}

