/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.db.core;

import java.util.Collection;
import org.apache.derby.drda.NetworkServerControl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.radrails.db.core.DatabaseDescriptor;
import org.radrails.db.core.DatabaseLog;
import org.radrails.db.core.DatabaseManager;
import org.radrails.db.core.ProjectDatabaseManager;

class DerbyStarter
extends Job {
    private static boolean derbyStarted = false;

    public DerbyStarter() {
        super("Checking if we need to start derby server");
        this.setSystem(true);
        this.setPriority(30);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.shouldStartDerby()) {
            return Status.CANCEL_STATUS;
        }
        DerbyStarter.start();
        return Status.OK_STATUS;
    }

    private boolean shouldStartDerby() {
        Collection<ProjectDatabaseManager> managers = DatabaseManager.getInstance().getAllProjectDatabaseManagers();
        for (ProjectDatabaseManager projectDatabaseManager : managers) {
            Collection<DatabaseDescriptor> descriptors = projectDatabaseManager.getDatabaseDescriptors();
            for (DatabaseDescriptor databaseDescriptor : descriptors) {
                String driver;
                String db = databaseDescriptor.getAdapter();
                if (!db.equalsIgnoreCase("jdbc") || !(driver = databaseDescriptor.getDriver()).equals("org.apache.derby.jdbc.ClientDriver")) continue;
                return true;
            }
        }
        return false;
    }

    public static void start() {
        if (derbyStarted) {
            return;
        }
        try {
            NetworkServerControl server = new NetworkServerControl();
            server.start(null);
            derbyStarted = true;
        }
        catch (Exception e) {
            DatabaseLog.log((Exception)e);
        }
    }
}

