/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.db.core;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.radrails.db.core.DatabaseDescriptor;
import org.radrails.db.core.DatabaseLog;
import org.radrails.db.core.IDatabaseListener;
import org.radrails.db.core.ProjectDatabaseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseManager
implements IResourceChangeListener {
    private static DatabaseManager instance;
    private Map<IProject, ProjectDatabaseManager> projectDatabaseManagerMap;
    private Set<IDatabaseListener> listeners = new HashSet<IDatabaseListener>();

    private DatabaseManager() {
        this.projectDatabaseManagerMap = new HashMap<IProject, ProjectDatabaseManager>();
        this.loadMap();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void loadMap() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].isOpen() && projects[i].exists() && projects[i].hasNature("org.radrails.rails.core.railsnature")) {
                    this.projectDatabaseManagerMap.put(projects[i], new ProjectDatabaseManager(projects[i]));
                }
            }
            catch (CoreException e) {
                DatabaseLog.logError((String)"Rails Project Nature not found", (Throwable)e);
            }
            ++i;
        }
    }

    public static DatabaseManager getInstance() {
        if (instance == null) {
            instance = new DatabaseManager();
        }
        return instance;
    }

    public ProjectDatabaseManager getProjectDatabaseManager(IProject project) {
        return this.projectDatabaseManagerMap.get(project);
    }

    public Collection<ProjectDatabaseManager> getAllProjectDatabaseManagers() {
        return this.projectDatabaseManagerMap.values();
    }

    public void addProjectDatabaseManager(IProject project) {
        this.projectDatabaseManagerMap.put(project, new ProjectDatabaseManager(project));
        this.notifyListeners();
    }

    private void notifyListeners() {
    }

    public void removeProjectDatabaseManager(IProject project) {
        this.projectDatabaseManagerMap.remove(project);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 1) {
            IResourceDelta[] resources = event.getDelta().getAffectedChildren();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i].getResource();
                if (resource instanceof IProject) {
                    IProject project = (IProject)resource;
                    try {
                        switch (resources[i].getKind()) {
                            case 1: {
                                if (project.hasNature("org.radrails.rails.core.railsnature")) {
                                    this.addProjectDatabaseManager(project);
                                    for (IDatabaseListener listener : this.listeners) {
                                        listener.projectAdded(project);
                                    }
                                }
                                break;
                            }
                            case 4: {
                                if (project.isOpen() && project.hasNature("org.radrails.rails.core.railsnature")) {
                                    this.addProjectDatabaseManager(project);
                                    for (IDatabaseListener listener : this.listeners) {
                                        listener.projectAdded(project);
                                    }
                                }
                                break;
                            }
                            case 2: {
                                this.removeProjectDatabaseManager(project);
                                for (IDatabaseListener listener : this.listeners) {
                                    listener.projectRemoved(project);
                                }
                            }
                        }
                    }
                    catch (CoreException e) {
                        DatabaseLog.logError((String)"Rails Project Nature not found", (Throwable)e);
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
    }

    public void stopAll() {
        try {
            Connection conn = DriverManager.getConnection("jdbc:derby:;shutdown=true");
            conn.close();
        }
        catch (Exception exception) {}
    }

    public void closeAll() {
    }

    public void addListener(IDatabaseListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IDatabaseListener listener) {
        this.listeners.remove(listener);
    }

    public static Set<String> getEnvironments() {
        HashSet<String> environments = new HashSet<String>();
        Collection<ProjectDatabaseManager> managers = DatabaseManager.getInstance().getAllProjectDatabaseManagers();
        for (ProjectDatabaseManager projectDatabaseManager : managers) {
            for (DatabaseDescriptor desc : projectDatabaseManager.getDatabaseDescriptors()) {
                environments.add(desc.getName());
            }
        }
        environments.add("development");
        environments.add("production");
        environments.add("test");
        return environments;
    }

    void databaseChanged(IProject project) {
        for (IDatabaseListener listener : this.listeners) {
            listener.databaseSettingsChanged(project);
        }
    }
}

