/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages.movemethod;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.refactoring.core.movemethod.MoveMethodConfig;
import org.rubypeople.rdt.refactoring.ui.pages.movemethod.Messages;

public class SecondMoveMethodPageComposite
extends Composite
implements Observer {
    private MoveMethodConfig config;
    private Label infoTextLabel;

    public SecondMoveMethodPageComposite(Composite parent, MoveMethodConfig config) {
        super(parent, 0);
        this.config = config;
        config.addObserver(this);
        this.setLayout((Layout)new GridLayout(1, true));
        this.init();
    }

    private void init() {
        this.initInformationText();
        this.initFieldSelection();
    }

    private void initInformationText() {
        this.infoTextLabel = new Label((Composite)this, 64);
        this.infoTextLabel.setLayoutData((Object)this.getGridData(true));
    }

    private GridData getGridData(boolean grab) {
        GridData gridData = new GridData();
        if (grab) {
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
        }
        return gridData;
    }

    private void initFieldSelection() {
        final Combo fieldSelectionCombo = new Combo((Composite)this, 12);
        fieldSelectionCombo.setVisibleItemCount(10);
        fieldSelectionCombo.setLayoutData((Object)this.getGridData(false));
        for (String fieldName : this.config.getFieldInSourceClassOfTypeDestinationClassNames()) {
            if (this.config.getFieldInSourceClassOfTypeDestinationClass() == null) {
                this.config.setFieldInSourceClassOfTypeDestinationClass(fieldName);
                fieldSelectionCombo.setText(fieldName);
            }
            fieldSelectionCombo.add(fieldName);
        }
        fieldSelectionCombo.select(0);
        fieldSelectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SecondMoveMethodPageComposite.this.config.setFieldInSourceClassOfTypeDestinationClass(fieldSelectionCombo.getText());
            }
        });
    }

    public void update(Observable arg0, Object arg1) {
        String selectedMethodName = this.config.getMethodNode().getName();
        String sourceClassName = this.config.getSourceClassNode().getName();
        String destClassName = this.config.getDestinationClassNode().getName();
        String infoText = String.valueOf(Messages.SecondMoveMethodPageComposite_MaintainCalls) + selectedMethodName + Messages.SecondMoveMethodPageComposite_FieldReference + destClassName + Messages.SecondMoveMethodPageComposite_RequiredInClass + sourceClassName + Messages.SecondMoveMethodPageComposite_SelectField;
        this.infoTextLabel.setText(infoText);
    }
}

