/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages.movemethod;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.refactoring.core.movemethod.MoveMethodConfig;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.pages.movemethod.Messages;

public class FirstMoveMethodPageComposite
extends Composite {
    private MoveMethodConfig config;

    public FirstMoveMethodPageComposite(Composite parent, MoveMethodConfig config) {
        super(parent, 0);
        this.config = config;
        this.initialize();
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout(2, false);
        this.setLayout((Layout)gridLayout);
        this.createSelectionGroup();
        this.createClassSelection();
        this.createLeaveDelegateMethodCheck();
    }

    private void createSelectionGroup() {
        String selectedMethodName = this.config.getMethodNode().getName();
        String selectedMethodVisibility = VisibilityNodeWrapper.getVisibilityName(this.config.getMethodVisibility());
        String selectedClassName = this.config.getSourceClassNode().getName();
        Group group = new Group((Composite)this, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.FirstMoveMethodPageComposite_Selection);
        group.setLayoutData((Object)this.getGridData(2, true));
        Label selectedMethodLabel = new Label((Composite)group, 0);
        selectedMethodLabel.setText(String.valueOf(Messages.FirstMoveMethodPageComposite_SelectedMethod) + selectedMethodName);
        Label visibilityLabel = new Label((Composite)group, 0);
        visibilityLabel.setText(String.valueOf(Messages.FirstMoveMethodPageComposite_Visibility) + selectedMethodVisibility);
        visibilityLabel.setLayoutData((Object)this.getGridData(1, true));
        Label selcetecClassLabel = new Label((Composite)group, 0);
        selcetecClassLabel.setText(String.valueOf(Messages.FirstMoveMethodPageComposite_SelectedClass) + selectedClassName);
        selcetecClassLabel.setLayoutData((Object)this.getGridData(1, true));
    }

    private GridData getGridData(int span, boolean fill) {
        GridData gridData = new GridData();
        if (span > 1) {
            gridData.horizontalSpan = span;
        }
        if (fill) {
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
        }
        return gridData;
    }

    private void createClassSelection() {
        Label moveToClassLabel = new Label((Composite)this, 0);
        moveToClassLabel.setText(Messages.FirstMoveMethodPageComposite_MoveToClass);
        final Combo classSelectionCombo = new Combo((Composite)this, 12);
        classSelectionCombo.setVisibleItemCount(10);
        for (String aktClassName : this.config.getTargetClassNames()) {
            if (this.config.getDestinationClassNode() == null) {
                this.config.setDestinationClassNode(aktClassName);
            }
            classSelectionCombo.add(aktClassName);
        }
        classSelectionCombo.select(0);
        classSelectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FirstMoveMethodPageComposite.this.config.setDestinationClassNode(classSelectionCombo.getText());
            }
        });
    }

    private void createLeaveDelegateMethodCheck() {
        final Button delegateCheck = new Button((Composite)this, 32);
        delegateCheck.setLayoutData((Object)this.getGridData(2, true));
        delegateCheck.setText(String.valueOf(Messages.FirstMoveMethodPageComposite_LeaveDelegate) + this.config.getSourceClassNode().getName() + Messages.FirstMoveMethodPageComposite_DelegatesCalls + this.config.getMethodNode().getName() + "\".");
        delegateCheck.setSelection(this.config.leaveDelegateMethodInSource());
        if (this.config.canCreateDelegateMethod()) {
            delegateCheck.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    FirstMoveMethodPageComposite.this.config.setLeaveDelegateMethodInSource(delegateCheck.getSelection());
                }
            });
        } else {
            delegateCheck.setEnabled(false);
        }
    }
}

