/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages.extractmethod;

import java.util.Observable;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.IValidationController;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.MethodArgumentTableItem;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.ParameterTextChanged;
import org.rubypeople.rdt.refactoring.util.NameValidator;

public class ParametersTableCellEditorListener
extends Observable
implements Listener {
    private final Table table;
    private final IValidationController validationController;

    public ParametersTableCellEditorListener(Table parametersTable, IValidationController validationController) {
        this.table = parametersTable;
        this.validationController = validationController;
    }

    private boolean areAllNamesUnique() {
        TableItem[] items = this.table.getItems();
        boolean unique = true;
        int outer = 0;
        while (outer < items.length) {
            int inner = 0;
            while (inner < items.length) {
                if (outer != inner && items[outer].getText().equals(items[inner].getText())) {
                    unique = false;
                }
                ++inner;
            }
            ++outer;
        }
        return unique;
    }

    private boolean areAllNamesValid(StringBuilder message) {
        TableItem[] items = this.table.getItems();
        boolean valid = true;
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (!NameValidator.isValidLocalVariableName(item.getText())) {
                valid = false;
                item.setBackground(new Color(this.table.getBackground().getDevice(), 255, 0, 0));
                message.append('\'');
                message.append(item.getText());
                message.append(Messages.ParametersTableCellEditorListener_IsNotValidParameterName);
            } else if (this.nameAlreadyUsed(item.getText())) {
                valid = false;
                message.append('\'');
                message.append(item.getText());
                message.append(Messages.ParametersTableCellEditorListener_IsAlreadyUsed);
            } else {
                item.setBackground(this.table.getBackground());
            }
            ++n2;
        }
        return valid;
    }

    private boolean nameAlreadyUsed(String name) {
        return this.validationController.getInvalidNames().contains(name);
    }

    private void setNewName(MethodArgumentTableItem item, Text text) {
        String oldName = item.getItemName();
        item.setItemName(text.getText());
        item.setText(text.getText());
        StringBuilder message = new StringBuilder();
        if (this.areAllNamesValid(message)) {
            this.setChanged();
            this.notifyObservers(new ParameterTextChanged(this.table.getSelectionIndex(), this.table.getSelectionIndex(), oldName, text.getText()));
        }
        if (!this.areAllNamesUnique()) {
            message.append(Messages.ParametersTableCellEditorListener_CannotHaveParametersWithEqualNames);
        }
        if (message.toString().equals("")) {
            this.validationController.setError(null);
            this.validationController.setComplete(this, true);
        } else {
            this.validationController.setError(message.toString());
            this.validationController.setComplete(this, false);
        }
    }

    public void handleEvent(Event event) {
        TableEditor editor = new TableEditor(this.table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        Rectangle clientArea = this.table.getClientArea();
        Rectangle bounds = this.table.getSelection()[0].getBounds();
        Point pt = new Point(bounds.x, bounds.y);
        int index = this.table.getTopIndex();
        while (index < this.table.getItemCount()) {
            boolean visible = false;
            MethodArgumentTableItem item = (MethodArgumentTableItem)this.table.getItem(index);
            int i = 0;
            while (i < this.table.getColumnCount()) {
                Rectangle rect = item.getBounds(i);
                if (rect.contains(pt)) {
                    Text text = new Text((Composite)this.table, 0);
                    TextListener textListener = new TextListener(item, text);
                    text.addListener(16, (Listener)textListener);
                    text.addListener(31, (Listener)textListener);
                    editor.setEditor((Control)text, (TableItem)item, i);
                    text.setText(item.getText(i));
                    text.selectAll();
                    text.setFocus();
                    return;
                }
                if (!visible && rect.intersects(clientArea)) {
                    visible = true;
                }
                ++i;
            }
            if (!visible) {
                return;
            }
            ++index;
        }
    }

    private final class TextListener
    implements Listener {
        private final MethodArgumentTableItem item;
        private final Text text;

        private TextListener(MethodArgumentTableItem item, Text text) {
            this.item = item;
            this.text = text;
        }

        public void handleEvent(Event e) {
            if (e.type == 16) {
                ParametersTableCellEditorListener.this.setNewName(this.item, this.text);
                this.text.dispose();
                ParametersTableCellEditorListener.this.table.setFocus();
            } else if (e.type == 31) {
                if (e.detail == 4) {
                    ParametersTableCellEditorListener.this.setNewName(this.item, this.text);
                }
                if (e.detail == 4 || e.detail == 2) {
                    this.text.dispose();
                    e.doit = false;
                }
            }
        }
    }
}

