/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.rubypeople.rdt.internal.refactoring.RefactoringMessages;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractedMethodHelper;
import org.rubypeople.rdt.refactoring.core.extractmethod.MethodExtractor;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.ButtonStateListener;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.ExtractMethodComposite;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.IValidationController;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.MethodArgumentTableItem;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.MethodNameListener;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.ParameterTextChanged;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.ParametersButtonDownListener;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.ParametersButtonUpListener;
import org.rubypeople.rdt.refactoring.ui.pages.extractmethod.SignatureObserver;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractMethodPage
extends RefactoringWizardPage
implements IValidationController {
    private static final String title = Messages.ExtractMethodPage_Title;
    private MethodExtractor methodExtractor;
    private ExtractMethodComposite extractComposite;
    private final IRefactoringContext selectionInformation;
    private ExtractedMethodHelper extractedMethod;
    private HashMap<Object, Boolean> completedValidators = new HashMap();

    public ExtractMethodPage(MethodExtractor methodExtractor, IRefactoringContext selectionInformation) {
        super(title);
        this.methodExtractor = methodExtractor;
        this.extractedMethod = methodExtractor.getExtractedMethod();
        this.selectionInformation = selectionInformation;
    }

    public void createControl(Composite parent) {
        this.extractComposite = new ExtractMethodComposite(parent, this, this.extractedMethod.hasArguments(), this.extractedMethod.getVisibility() != VisibilityNodeWrapper.METHOD_VISIBILITY.NONE);
        this.extractedMethod.addObserver(new SignatureObserver(this.extractComposite.getMethodSignaturePreviewLabel(), this.extractedMethod));
        if (this.extractedMethod.hasArguments()) {
            this.setupArgumentsTable(this.extractComposite.getParametersTable(), this.extractComposite.getUpParametersButton(), this.extractComposite.getDownParametersButton(), this.extractComposite.getEditParametersButton());
        }
        this.setControl((Control)this.extractComposite);
        this.addNewMethodNameListener();
        if (this.extractedMethod.getVisibility() != VisibilityNodeWrapper.METHOD_VISIBILITY.NONE) {
            this.setupVisibilityHandlers();
        }
        if (this.extractComposite.getCellEditorListener() != null) {
            this.extractComposite.getCellEditorListener().addObserver(new ItemNameObserver());
        }
        this.setupSelectionPreview();
        final Button replaceAllInstance = new Button((Composite)this.extractComposite, 32);
        GridData checkData = new GridData();
        replaceAllInstance.setLayoutData((Object)checkData);
        replaceAllInstance.setText(RefactoringMessages.ExtractConstantInputPage_replace_all_occurrences);
        replaceAllInstance.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExtractMethodPage.this.methodExtractor.setReplaceAllInstances(replaceAllInstance.getSelection());
            }
        });
    }

    private void setupSelectionPreview() {
        this.extractComposite.getCodeViewer().setPreviewText(this.selectionInformation.getSource());
        int nodeStart = NodeUtil.subPositionUnion(this.extractedMethod.getSelectedNodes()).getStartOffset();
        int nodeLength = NodeUtil.subPositionUnion(this.extractedMethod.getSelectedNodes()).getEndOffset() - nodeStart;
        this.extractComposite.getCodeViewer().setBackgroundColor(nodeStart, nodeLength, 15);
        int selectionStart = this.selectionInformation.getStartOffset();
        int selectionLength = this.selectionInformation.getEndOffset() - selectionStart + 1;
        this.extractComposite.getCodeViewer().setBackgroundColor(selectionStart, selectionLength, 16);
        this.scrollToSelection();
    }

    private void setupVisibilityHandlers() {
        if (ExtractedMethodHelper.DEFAULT_VISIBILITY.equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.PRIVATE)) {
            this.extractComposite.getPrivateAccessRadioButton().setSelection(true);
        } else if (ExtractedMethodHelper.DEFAULT_VISIBILITY.equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.PROTECTED)) {
            this.extractComposite.getProtectedAccessRadioButton().setSelection(true);
        } else if (ExtractedMethodHelper.DEFAULT_VISIBILITY.equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC)) {
            this.extractComposite.getPublicAccessRadioButton().setSelection(true);
        }
        this.extractComposite.getPrivateAccessRadioButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExtractMethodPage.this.extractedMethod.setVisibility(VisibilityNodeWrapper.METHOD_VISIBILITY.PRIVATE);
            }
        });
        this.extractComposite.getPublicAccessRadioButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExtractMethodPage.this.extractedMethod.setVisibility(VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC);
            }
        });
        this.extractComposite.getProtectedAccessRadioButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExtractMethodPage.this.extractedMethod.setVisibility(VisibilityNodeWrapper.METHOD_VISIBILITY.PROTECTED);
            }
        });
        this.extractComposite.getNoneAccessRadioButton().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExtractMethodPage.this.extractedMethod.setVisibility(VisibilityNodeWrapper.METHOD_VISIBILITY.NONE);
            }
        });
    }

    private void setupArgumentsTable(Table table, Button upButton, Button downButton, Button editButton) {
        this.insertParameterItems(table);
        ParametersButtonUpListener upListener = new ParametersButtonUpListener(this.extractComposite.getParametersTable());
        ParametersButtonDownListener downListener = new ParametersButtonDownListener(this.extractComposite.getParametersTable());
        this.extractComposite.getUpParametersButton().addListener(13, (Listener)upListener);
        this.extractComposite.getDownParametersButton().addListener(13, (Listener)downListener);
        ButtonStateListener listener = new ButtonStateListener(table, upButton, downButton, editButton);
        upListener.addObserver(listener);
        downListener.addObserver(listener);
        upListener.addObserver(new ItemOrderObserver());
        downListener.addObserver(new ItemOrderObserver());
        table.addListener(13, (Listener)listener);
    }

    private void insertParameterItems(Table table) {
        String[] names = this.extractedMethod.getArguments().toArray(new String[this.extractedMethod.getArguments().size()]);
        int i = 0;
        while (i < names.length) {
            new MethodArgumentTableItem(table, names[i], true, i, i);
            ++i;
        }
    }

    private void addNewMethodNameListener() {
        MethodNameListener methodNameListener = new MethodNameListener(this.methodExtractor, this);
        this.extractComposite.getNewMethodNameText().getText().addModifyListener((ModifyListener)methodNameListener);
        this.setComplete(methodNameListener, false);
    }

    @Override
    public void setError(String message) {
        this.setMessage(message, 3);
    }

    @Override
    public void setComplete(Object source, boolean complete) {
        this.completedValidators.put(source, complete);
        boolean allOk = true;
        for (boolean ok : this.completedValidators.values()) {
            if (ok) continue;
            allOk = false;
        }
        this.setPageComplete(allOk);
    }

    public void scrollToSelection() {
        this.extractComposite.getCodeViewer().getTextWidget().setSelection(this.selectionInformation.getStartOffset());
        this.extractComposite.getCodeViewer().getTextWidget().setSelection(this.selectionInformation.getEndOffset());
        this.extractComposite.getCodeViewer().getTextWidget().showSelection();
    }

    @Override
    public ArrayList<String> getInvalidNames() {
        return this.extractedMethod.getLocalOnlyVariables();
    }

    private class ItemNameObserver
    implements Observer {
        private ItemNameObserver() {
        }

        public void update(Observable o, Object arg) {
            ParameterTextChanged change = (ParameterTextChanged)arg;
            ExtractMethodPage.this.extractedMethod.changeParameter(change.getOriginalPosition(), change.getTo());
        }
    }

    private class ItemOrderObserver
    implements Observer {
        private ItemOrderObserver() {
        }

        public void update(Observable o, Object arg) {
            ParameterTextChanged change = (ParameterTextChanged)arg;
            ExtractMethodPage.this.extractedMethod.changeParameter(change.getOriginalPosition(), change.getNewPosition());
        }
    }
}

