/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui.pages;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.refactoring.core.encapsulatefield.FieldEncapsulator;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;
import org.rubypeople.rdt.refactoring.ui.pages.Messages;
import org.rubypeople.rdt.refactoring.ui.pages.RefactoringWizardPage;
import org.rubypeople.rdt.refactoring.ui.pages.encapsulatefield.EncapsulateFieldAccessorComposite;
import org.rubypeople.rdt.refactoring.ui.pages.encapsulatefield.IVisibilitySelectionListener;
import org.rubypeople.rdt.refactoring.ui.util.AbstractSelectionListener;

public class EncapsulateFieldPage
extends RefactoringWizardPage {
    private static final String TITLE = Messages.EncapsulateFieldPage_Title;
    private FieldEncapsulator fieldEncapsulator;

    public EncapsulateFieldPage(FieldEncapsulator fieldEncapsulator) {
        super(TITLE);
        this.fieldEncapsulator = fieldEncapsulator;
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(1, true));
        this.initFieldInfoGroup(control);
        this.initReaderAccessorControl(control);
        this.initWriterAccessorControl(control);
        this.setControl((Control)control);
    }

    private void initWriterAccessorControl(Composite parent) {
        boolean isOptional = this.fieldEncapsulator.isWriterGenerationOptional();
        VisibilityNodeWrapper.METHOD_VISIBILITY visibility = this.fieldEncapsulator.getWriterVisibility();
        final EncapsulateFieldAccessorComposite accessorControl = new EncapsulateFieldAccessorComposite(parent, Messages.EncapsulateFieldPage_Writer, visibility, isOptional);
        accessorControl.enableVisibilityGroup(false);
        if (isOptional) {
            accessorControl.addEnableDisableListener(new AbstractSelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    EncapsulateFieldPage.this.fieldEncapsulator.setWriterDisabled(accessorControl.isDisabled());
                    accessorControl.enableVisibilityGroup(!accessorControl.isDisabled());
                }
            });
        }
        accessorControl.addVisibilitySelectionListener(new IVisibilitySelectionListener(){

            public void visibilitySelected(VisibilityNodeWrapper.METHOD_VISIBILITY visibility) {
                EncapsulateFieldPage.this.fieldEncapsulator.setWriterVisibility(visibility);
            }
        });
    }

    private void initReaderAccessorControl(Composite parent) {
        boolean isOptional = this.fieldEncapsulator.isReaderGenerationOptional();
        VisibilityNodeWrapper.METHOD_VISIBILITY visibility = this.fieldEncapsulator.getReaderVisibility();
        final EncapsulateFieldAccessorComposite accessorControl = new EncapsulateFieldAccessorComposite(parent, Messages.EncapsulateFieldPage_Reader, visibility, isOptional);
        accessorControl.enableVisibilityGroup(false);
        if (isOptional) {
            accessorControl.addEnableDisableListener(new AbstractSelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    EncapsulateFieldPage.this.fieldEncapsulator.setReaderDisabled(accessorControl.isDisabled());
                    accessorControl.enableVisibilityGroup(!accessorControl.isDisabled());
                }
            });
        }
        accessorControl.addVisibilitySelectionListener(new IVisibilitySelectionListener(){

            public void visibilitySelected(VisibilityNodeWrapper.METHOD_VISIBILITY visibility) {
                EncapsulateFieldPage.this.fieldEncapsulator.setReaderVisibility(visibility);
            }
        });
    }

    private void initFieldInfoGroup(Composite control) {
        Group fieldInfoGroup = new Group(control, 0);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        fieldInfoGroup.setLayoutData((Object)gridData);
        fieldInfoGroup.setLayout((Layout)new GridLayout(1, true));
        fieldInfoGroup.setText(Messages.EncapsulateFieldPage_SelectedField);
        Label fieldNameLabel = new Label((Composite)fieldInfoGroup, 0);
        fieldNameLabel.setText(String.valueOf(Messages.EncapsulateFieldPage_Name) + this.fieldEncapsulator.getSelectedFieldName());
        Label existingAccessorLabel = new Label((Composite)fieldInfoGroup, 0);
        existingAccessorLabel.setText(String.valueOf(Messages.EncapsulateFieldPage_FieldAccessor) + this.fieldEncapsulator.getExistingAccessorName());
    }
}

