/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.ui;

import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.rubypeople.rdt.refactoring.ui.CheckableItem;
import org.rubypeople.rdt.refactoring.ui.IChildrenProvider;
import org.rubypeople.rdt.refactoring.ui.IParentProvider;

public class ConstructorGenerationTree
extends CheckboxTreeViewer {
    public ConstructorGenerationTree(Composite parent, ITreeContentProvider contentProvider) {
        super(parent);
        this.setAutoExpandLevel(3);
        this.setContentProvider((IContentProvider)contentProvider);
        this.setInput("");
        this.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ConstructorGenerationTree.this.handleItemChecked(event.getChecked(), event.getElement());
            }
        });
    }

    protected void handleItemChecked(boolean checked, Object element) {
        if (element instanceof CheckableItem) {
            CheckableItem checkableItem = (CheckableItem)element;
            this.setItemChecked(checkableItem, checked);
            if (checkableItem.autoCheckParentOnCheck() && checkableItem instanceof IParentProvider) {
                this.setParentChecked((IParentProvider)((Object)checkableItem));
            }
            if (checkableItem.autoUncheckChildsOnUncheck() && checkableItem instanceof IChildrenProvider) {
                this.setChildrenUnchecked((IChildrenProvider)((Object)checkableItem));
            }
        }
    }

    protected void setItemChecked(CheckableItem item, boolean checked) {
        item.setChecked(checked);
    }

    protected void setChildrenUnchecked(IChildrenProvider item) {
        Object[] objectArray = item.getChildren();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object attr = objectArray[n2];
            this.setChecked(attr, false);
            this.setItemChecked((CheckableItem)attr, false);
            ++n2;
        }
    }

    protected void setParentChecked(IParentProvider item) {
        this.setChecked(item.getParent(), true);
        this.setItemChecked((CheckableItem)item.getParent(), true);
    }
}

