/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.signatureprovider;

import java.util.ArrayList;
import java.util.Collection;
import org.rubypeople.rdt.refactoring.nodewrapper.ArgsNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSignature {
    private String methodName;
    private Collection<String> args;

    public MethodSignature(String methodName, Collection<String> args) {
        this.methodName = methodName;
        this.args = args;
    }

    public MethodSignature(String methodName, int argCount) {
        this(methodName, MethodSignature.getAnnonymousArgs(argCount));
    }

    public MethodSignature(String methodName, ArgsNodeWrapper args) {
        this(methodName, args.getArgsList());
    }

    private static Collection<String> getAnnonymousArgs(int argCount) {
        ArrayList<String> args = new ArrayList<String>();
        int i = 0;
        while (i < argCount) {
            args.add("arg" + i);
            ++i;
        }
        return args;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Collection<String> getArguments() {
        return this.args;
    }

    public String getArgListAsString() {
        if (this.args.isEmpty()) {
            return "";
        }
        StringBuilder argList = new StringBuilder();
        for (String arg : this.args) {
            argList.append(String.valueOf(arg) + ", ");
        }
        return String.valueOf(' ') + argList.substring(0, argList.length() - 2);
    }

    public boolean isConstructor() {
        return this.methodName.equals("initialize");
    }

    public String getNameWithArgs() {
        String argsList = this.getArgListAsString();
        return String.valueOf(this.getMethodName()) + (argsList.length() != 0 ? argsList : "");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.args == null ? 0 : this.args.hashCode());
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodSignature) {
            MethodSignature otherSignature = (MethodSignature)obj;
            if (this.getNameWithArgs().equals(otherSignature.getNameWithArgs())) {
                return true;
            }
        }
        return false;
    }
}

