/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.signatureprovider;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.exception.UnknownClassNameException;
import org.rubypeople.rdt.refactoring.exception.UnknownMethodNameException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.signatureprovider.ClassNodeSignatureProvider;
import org.rubypeople.rdt.refactoring.signatureprovider.IClassSignatureProvider;
import org.rubypeople.rdt.refactoring.signatureprovider.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassSignatureProvider
implements IClassSignatureProvider {
    private Map<String, Object> methodSignatures = new LinkedHashMap<String, Object>();
    private IClassSignatureProvider superProvider;

    @Override
    public abstract String getClassName();

    protected abstract MethodSignature getSignature(String var1, Object var2);

    public ClassSignatureProvider(IClassSignatureProvider superProvider) {
        this.superProvider = superProvider;
    }

    protected void addMethodSignature(String methodName, Object data) {
        this.methodSignatures.put(methodName, data);
    }

    @Override
    public boolean hasMethodSignature(String methodName) {
        if (this.methodSignatures.containsKey(methodName)) {
            return true;
        }
        if (this.superProvider != null) {
            return this.superProvider.hasMethodSignature(methodName);
        }
        return false;
    }

    @Override
    public MethodSignature getMethodSignature(String methodName) throws UnknownMethodNameException {
        if (this.methodSignatures.containsKey(methodName)) {
            return this.getSignature(methodName, this.methodSignatures.get(methodName));
        }
        if (this.superProvider != null) {
            return this.superProvider.getMethodSignature(methodName);
        }
        throw new UnknownMethodNameException();
    }

    @Override
    public Collection<MethodSignature> getMethodSignatures() {
        LinkedHashSet<MethodSignature> signs = new LinkedHashSet<MethodSignature>();
        for (String methodName : this.methodSignatures.keySet()) {
            signs.add(this.getSignature(methodName, this.methodSignatures.get(methodName)));
        }
        if (this.superProvider != null) {
            signs.addAll(this.superProvider.getMethodSignatures());
        }
        return signs;
    }

    @Override
    public boolean hasConstructorSignature() {
        return this.hasMethodSignature("initialize");
    }

    @Override
    public MethodSignature getConstructorSignature() throws UnknownMethodNameException {
        return this.getMethodSignature("initialize");
    }

    public static IClassSignatureProvider getClassSignatureProvider(String className, ClassNodeProvider classNodeProvider) throws UnknownClassNameException {
        ClassNodeWrapper classNode = null;
        if (classNodeProvider != null) {
            classNode = classNodeProvider.getClassNode(className);
        }
        if (classNode != null) {
            return new ClassNodeSignatureProvider(classNode, classNodeProvider);
        }
        throw new UnknownClassNameException();
    }

    protected Object getData(String methodName) {
        return this.methodSignatures.get(methodName);
    }
}

