/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.SClassNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.exception.UnknownReferenceException;
import org.rubypeople.rdt.refactoring.nodewrapper.Messages;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SClassNodeWrapper
extends PartialClassNodeWrapper {
    private SClassNode wrappedNode;
    Map<Integer, Node> references;

    public SClassNodeWrapper(Node node, Node rootNode) {
        super(node);
        this.wrappedNode = (SClassNode)node;
        this.references = this.buildReferences(rootNode);
    }

    @Override
    public String getSuperClassName() {
        return "";
    }

    @Override
    public String getClassName() {
        Node receiverNode = this.wrappedNode.getReceiverNode();
        if (receiverNode instanceof LocalVarNode) {
            LocalVarNode localVarNode = (LocalVarNode)receiverNode;
            try {
                Node referencedNode = this.getReferencedNode(localVarNode.getIndex(), this.references);
                if (referencedNode instanceof INameNode) {
                    return String.valueOf(this.getModulePrefix()) + ((INameNode)referencedNode).getName();
                }
            }
            catch (UnknownReferenceException e) {
                e.printStackTrace();
            }
        } else if (receiverNode instanceof VCallNode) {
            VCallNode vCallNode = (VCallNode)receiverNode;
            return String.valueOf(this.getModulePrefix()) + vCallNode.getName();
        }
        return String.valueOf(Messages.SClassNodeWrapper_UnknownNode) + receiverNode.toString();
    }

    private Node getReferencedNode(int id, Map<Integer, Node> references) throws UnknownReferenceException {
        if (references.containsKey(id)) {
            return references.get(id);
        }
        throw new UnknownReferenceException();
    }

    @Override
    public Node getClassBodyNode() {
        return this.wrappedNode.getBodyNode();
    }

    @Override
    public Node getDeclarationEndNode() {
        return this.wrappedNode.getReceiverNode();
    }

    private Map<Integer, Node> buildReferences(Node root) {
        HashMap<Integer, Node> references = new HashMap<Integer, Node>();
        Collection<Node> referencedNodes = NodeProvider.getSubNodes(root, LocalAsgnNode.class);
        for (Node node : referencedNodes) {
            if (!(node instanceof LocalAsgnNode)) continue;
            LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
            references.put(localAsgnNode.getIndex(), node);
        }
        return references;
    }
}

