/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.FCallNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.VCallNode;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.renamemodule.ModuleSpecifierWrapper;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.RealClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.SClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PartialClassNodeWrapper
implements INodeWrapper {
    private Node wrappedNode;
    private Collection<ModuleNode> enclosingModules;
    private Collection<MethodNodeWrapper> methods;
    private Collection<FieldNodeWrapper> fields;
    private Collection<Node> attributes;

    public PartialClassNodeWrapper(Node node) {
        this.wrappedNode = node;
    }

    public Collection<FieldNodeWrapper> getFields() {
        if (this.fields == null) {
            this.fields = PartialClassNodeWrapper.getFieldsFromNode(this.wrappedNode);
        }
        return this.fields;
    }

    public static Collection<FieldNodeWrapper> getFieldsFromNode(Node wrappedNode) {
        ArrayList<FieldNodeWrapper> fields = new ArrayList<FieldNodeWrapper>();
        Collection<Node> fieldNodes = NodeProvider.getSubNodes(wrappedNode, FieldNodeWrapper.FIELD_NODE_CLASSES_WITHOUT_SYMBOL_NODE);
        for (Node currentField : fieldNodes) {
            fields.add(new FieldNodeWrapper(currentField));
        }
        PartialClassNodeWrapper.addSymbolNodeFields(fields, wrappedNode);
        return fields;
    }

    private static void addSymbolNodeFields(Collection<FieldNodeWrapper> fields, Node wrappedNode) {
        Collection<AttrAccessorNodeWrapper> accessors = NodeProvider.getAccessorNodes(wrappedNode);
        for (AttrAccessorNodeWrapper aktAcessor : accessors) {
            fields.add(new FieldNodeWrapper((Node)aktAcessor.getSymbolNode()));
        }
        for (Node aktNode : NodeProvider.getSubNodes(wrappedNode, FCallNode.class)) {
            FCallNode aktFCallNode = (FCallNode)aktNode;
            if (!aktFCallNode.getName().equals("attr")) continue;
            PartialClassNodeWrapper.addAttrNodeFields(aktFCallNode, fields);
        }
    }

    private static void addAttrNodeFields(FCallNode callNode, Collection<FieldNodeWrapper> fields) {
        if (NodeUtil.nodeAssignableFrom(callNode.getArgsNode(), ArrayNode.class)) {
            for (Object o : callNode.getArgsNode().childNodes()) {
                Node aktNode = (Node)o;
                if (!NodeUtil.nodeAssignableFrom(aktNode, SymbolNode.class)) continue;
                SymbolNode symbolNode = (SymbolNode)aktNode;
                fields.add(new FieldNodeWrapper((Node)symbolNode));
            }
        }
    }

    public Collection<MethodNodeWrapper> getMethods() {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodNodeWrapper>();
            Collection<Node> methodNodes = NodeProvider.getSubNodes(this.wrappedNode, MethodDefNode.class);
            for (Node methodNode : methodNodes) {
                this.methods.add(new MethodNodeWrapper((MethodDefNode)methodNode, new ClassNodeWrapper(this)));
            }
        }
        return this.methods;
    }

    public abstract Node getClassBodyNode();

    public abstract String getClassName();

    @Override
    public Node getWrappedNode() {
        return this.wrappedNode;
    }

    public abstract Node getDeclarationEndNode();

    public abstract String getSuperClassName();

    public Collection<Node> getAttrNodes() {
        if (this.attributes == null) {
            Collection<Node> allAttrs = NodeProvider.getAttributeNodes(this.wrappedNode);
            this.attributes = new ArrayList<Node>();
            for (Node node : allAttrs) {
                if (this.isDirectChild(node)) continue;
                this.attributes.add(node);
            }
        }
        return this.attributes;
    }

    private boolean isDirectChild(Node child) {
        return this.isDirectChild(child, this.wrappedNode);
    }

    private boolean isDirectChild(Node child, Node parent) {
        for (Object aktChild : parent.childNodes()) {
            if (aktChild.equals(child)) {
                return true;
            }
            if (!this.ignoreInDirectChildLine((Node)aktChild) || !this.isDirectChild(child, (Node)aktChild)) continue;
            return true;
        }
        return false;
    }

    private boolean ignoreInDirectChildLine(Node node) {
        return node instanceof NewlineNode || node instanceof BlockNode;
    }

    public static PartialClassNodeWrapper getPartialClassNodeWrapper(Node node, Node rootNode) throws NoClassNodeException {
        if (node instanceof ClassNode) {
            return new RealClassNodeWrapper(node);
        }
        if (node instanceof SClassNode) {
            return new SClassNodeWrapper(node, rootNode);
        }
        throw new NoClassNodeException();
    }

    public Collection<AttrAccessorNodeWrapper> getAccessorNodes() {
        return NodeProvider.getAccessorNodes(this.wrappedNode);
    }

    public String getFile() {
        return this.wrappedNode.getPosition().getFile();
    }

    public void setEnclosingModules(Collection<ModuleNode> enclosingModules) {
        if (enclosingModules.size() > 0) {
            this.enclosingModules = enclosingModules;
        }
    }

    public String getModulePrefix() {
        if (this.enclosingModules == null) {
            return "";
        }
        StringBuilder modulePrefix = new StringBuilder();
        Iterator<ModuleNode> it = this.enclosingModules.iterator();
        while (it.hasNext()) {
            ModuleNode currentModule = it.next();
            Colon3Node cPath = currentModule.getCPath();
            if (!(cPath instanceof Colon2Node)) continue;
            modulePrefix.append(((Colon2Node)cPath).getName());
            if (!it.hasNext()) continue;
            modulePrefix.append("::");
        }
        return modulePrefix.toString();
    }

    public Collection<Node> getInstFieldOccurences() {
        return NodeProvider.getInstFieldOccurences(this.wrappedNode);
    }

    public Collection<Node> getClassFieldOccurences() {
        return NodeProvider.getClassFieldOccurences(this.wrappedNode);
    }

    public Collection<ModuleSpecifierWrapper> getIncludeCalls() {
        ArrayList<ModuleSpecifierWrapper> includes = new ArrayList<ModuleSpecifierWrapper>();
        for (Node node : NodeProvider.getSubNodes(this.wrappedNode, FCallNode.class)) {
            FCallNode call = (FCallNode)node;
            if (!"include".equals(call.getName())) continue;
            includes.add(ModuleSpecifierWrapper.create(((ArrayNode)call.getArgsNode()).get(0), this.getModulePrefix()));
        }
        return includes;
    }

    public Collection<MethodCallNodeWrapper> getMethodCalls(MethodDefNode decoratedMethod) {
        ArrayList<MethodCallNodeWrapper> localCalls = new ArrayList<MethodCallNodeWrapper>();
        Collection<Node> callNodes = NodeProvider.getSubNodes(this.wrappedNode, VCallNode.class, CallNode.class, FCallNode.class);
        for (Node currentCall : callNodes) {
            MethodCallNodeWrapper callNode = new MethodCallNodeWrapper(currentCall);
            if (!callNode.getName().equals(decoratedMethod.getName())) continue;
            localCalls.add(callNode);
        }
        return localCalls;
    }

    public Collection<SymbolNode> getMethodSymbols(MethodDefNode decoratedNode) {
        ArrayList<SymbolNode> localSymbols = new ArrayList<SymbolNode>();
        Collection<Node> fCallNodes = NodeProvider.getSubNodes(this.wrappedNode, FCallNode.class);
        for (Node currentCall : fCallNodes) {
            FCallNode currentFCall = (FCallNode)currentCall;
            String callName = currentFCall.getName();
            if (!VisibilityNodeWrapper.isVisibilityString(callName) && !"alias_method".equals(callName)) continue;
            Collection<Node> symbolNodes = NodeProvider.getSubNodes((Node)currentFCall, SymbolNode.class);
            for (Node currentItem : symbolNodes) {
                SymbolNode currentSymbol = (SymbolNode)currentItem;
                if (!currentSymbol.getName().equals(decoratedNode.getName())) continue;
                localSymbols.add(currentSymbol);
            }
        }
        return localSymbols;
    }

    public VisibilityNodeWrapper.METHOD_VISIBILITY getPosVisibility(int pos) {
        Collection<Node> vCallNodes = NodeProvider.getSubNodes(this.wrappedNode, VCallNode.class);
        VCallNode lastMatch = null;
        for (Node aktNode : vCallNodes) {
            VCallNode aktVCallNode = (VCallNode)aktNode;
            if (!VisibilityNodeWrapper.isVisibilityString(aktVCallNode.getName())) continue;
            if (aktVCallNode.getPosition().getEndOffset() > pos) break;
            lastMatch = aktVCallNode;
        }
        if (lastMatch == null) {
            return VisibilityNodeWrapper.METHOD_VISIBILITY.PUBLIC;
        }
        return VisibilityNodeWrapper.getVisibility(lastMatch.getName());
    }

    public Collection<MethodCallNodeWrapper> getMethodCallNodes() {
        return NodeProvider.getMethodCallNodes(this.wrappedNode);
    }

    public Collection<MethodNodeWrapper> getExistingConstructors() {
        Collection<MethodNodeWrapper> methodNodes = this.getMethods();
        ArrayList<MethodNodeWrapper> constructors = new ArrayList<MethodNodeWrapper>();
        for (MethodNodeWrapper aktMethod : methodNodes) {
            if (!aktMethod.isConstructor()) continue;
            constructors.add(aktMethod);
        }
        return constructors;
    }

    public Collection<VisibilityNodeWrapper> getMethodVisibilityNodes() {
        Collection<Node> fCallNodes = NodeProvider.getSubNodes(this.wrappedNode, FCallNode.class);
        ArrayList<VisibilityNodeWrapper> visibilities = new ArrayList<VisibilityNodeWrapper>();
        for (Node aktNode : fCallNodes) {
            FCallNode aktFCallNode = (FCallNode)aktNode;
            if (!VisibilityNodeWrapper.isVisibilityString(aktFCallNode.getName())) continue;
            visibilities.add(new VisibilityNodeWrapper(aktFCallNode));
        }
        return visibilities;
    }
}

