/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.DefsNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.SymbolNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ArgsNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.signatureprovider.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodNodeWrapper
implements INodeWrapper {
    protected MethodDefNode methodNode;
    private final ClassNodeWrapper containingClass;

    public MethodNodeWrapper(MethodDefNode methodDef, ClassNodeWrapper containingClass) {
        this.methodNode = methodDef;
        this.containingClass = containingClass;
    }

    public String getName() {
        return this.methodNode.getName();
    }

    public MethodSignature getSignature() {
        return new MethodSignature(this.methodNode.getName(), this.getArgsNode());
    }

    public ArgsNodeWrapper getArgsNode() {
        return new ArgsNodeWrapper(this.methodNode.getArgsNode());
    }

    public MethodDefNode getWrappedNode() {
        return this.methodNode;
    }

    public boolean isClassMethod() {
        return this.methodNode instanceof DefsNode;
    }

    public Collection<MethodCallNodeWrapper> getMethodCallNodes() {
        return NodeProvider.getMethodCallNodes((Node)this.methodNode);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isClassMethod() ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodNodeWrapper) {
            MethodNodeWrapper otherMethodNode = (MethodNodeWrapper)obj;
            return this.getSignature().equals(otherMethodNode.getSignature());
        }
        return false;
    }

    public boolean isConstructor() {
        return this.getName().equals("initialize");
    }

    public ISourcePosition getPosition() {
        return this.methodNode.getPosition();
    }

    public String[] getLocalNames() {
        return this.methodNode.getScope().getVariables();
    }

    public Node getBodyNode() {
        return this.methodNode.getBodyNode();
    }

    public Collection<MethodCallNodeWrapper> getCallCandidatesInClass(ClassNodeWrapper classNode) {
        if (classNode == null) {
            return new ArrayList<MethodCallNodeWrapper>();
        }
        return classNode.getMethodCalls(this.methodNode);
    }

    public Collection<SymbolNode> getSymbolCandidatesInClass(ClassNodeWrapper classNode) {
        if (classNode == null) {
            return new ArrayList<SymbolNode>();
        }
        return classNode.getMethodSymbols(this.methodNode);
    }

    public boolean isAccessor() {
        return this.isWriter() || this.isReader();
    }

    public boolean isWriter() {
        if (this.containingClass == null) {
            return false;
        }
        for (FieldNodeWrapper field : this.containingClass.getFields()) {
            if (!(String.valueOf(field.getNameWithoutAts()) + "=").equals(this.getName()) || this.getSignature().getArguments().size() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean isReader() {
        if (this.containingClass == null) {
            return false;
        }
        for (FieldNodeWrapper field : this.containingClass.getFields()) {
            if (!field.getNameWithoutAts().equals(this.getName()) || !this.getSignature().getArguments().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

