/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.SymbolNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class FieldNodeWrapper
implements INodeWrapper {
    public static final int INVALID_TYPE = -1;
    public static final int INST_ASGN_NODE = 1;
    public static final int INST_VAR_NODE = 2;
    public static final int CLASS_VAR_ASGN_NODE = 3;
    public static final int CLASS_VAR_NODE = 4;
    public static final int SYMBOL_NODE = 5;
    public static final int CLASS_VAR_DECL_NODE = 6;
    static final Class[] FIELD_NODE_CLASSES = new Class[]{InstAsgnNode.class, InstVarNode.class, ClassVarAsgnNode.class, ClassVarNode.class, ClassVarDeclNode.class, SymbolNode.class};
    static final Class[] FIELD_NODE_CLASSES_WITHOUT_SYMBOL_NODE = new Class[]{InstAsgnNode.class, InstVarNode.class, ClassVarAsgnNode.class, ClassVarNode.class, ClassVarDeclNode.class};
    public static final String ATTR_NAME = "attr";
    private Node wrappedNode;
    private int nodeType = -1;
    private String name;

    public FieldNodeWrapper(Node node) {
        if (NodeUtil.nodeAssignableFrom(node, InstAsgnNode.class)) {
            this.nodeType = 1;
            InstAsgnNode instAsgnNode = (InstAsgnNode)node;
            this.name = instAsgnNode.getName();
        } else if (NodeUtil.nodeAssignableFrom(node, InstVarNode.class)) {
            InstVarNode instVarNode = (InstVarNode)node;
            this.name = instVarNode.getName();
            this.nodeType = 2;
        } else if (NodeUtil.nodeAssignableFrom(node, ClassVarAsgnNode.class)) {
            ClassVarAsgnNode classVarAsgnNode = (ClassVarAsgnNode)node;
            this.name = classVarAsgnNode.getName();
            this.nodeType = 3;
        } else if (NodeUtil.nodeAssignableFrom(node, ClassVarNode.class)) {
            ClassVarNode classVarNode = (ClassVarNode)node;
            this.name = classVarNode.getName();
            this.nodeType = 4;
        } else if (NodeUtil.nodeAssignableFrom(node, SymbolNode.class)) {
            SymbolNode symbolNode = (SymbolNode)node;
            this.name = symbolNode.getName();
            this.nodeType = 5;
        } else if (NodeUtil.nodeAssignableFrom(node, ClassVarDeclNode.class)) {
            ClassVarDeclNode classVarDeclNode = (ClassVarDeclNode)node;
            this.name = classVarDeclNode.getName();
            this.nodeType = 6;
        }
        this.wrappedNode = node;
    }

    public Node getWrappedNode() {
        return this.wrappedNode;
    }

    public String getName() {
        return this.name;
    }

    public String getNameWithoutAts() {
        return this.name.replaceFirst("^@{1,2}", "");
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public boolean isInstVar() {
        return this.nodeType == 1 || this.nodeType == 2 || this.nodeType == 5;
    }

    public boolean isClassVar() {
        return this.nodeType == 3 || this.nodeType == 4 || this.nodeType == 6;
    }

    public boolean isAsgnNode() {
        return this.nodeType == 1 || this.nodeType == 3 || this.nodeType == 6;
    }

    public ISourcePosition getPosition() {
        return this.wrappedNode.getPosition();
    }

    public static Class[] fieldNodeClasses() {
        return (Class[])FIELD_NODE_CLASSES.clone();
    }
}

