/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.nodewrapper;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.ast.SymbolNode;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrAccessorNodeWrapper
implements INodeWrapper {
    private Collection<FCallNode> callNodes;
    private AccessorType accessorType;
    private String name;
    private String fileName;
    private SymbolNode symbolNode;
    public static final String ATTR_WRITER = "attr_writer";
    public static final String ATTR_READER = "attr_reader";
    public static final String ATTR_ACCESSOR = "attr_accessor";
    private static final String[] typeNames = new String[]{"attr_writer", "attr_reader", "attr_accessor"};

    public AttrAccessorNodeWrapper(FCallNode callNode, SymbolNode symbolNode) {
        this.symbolNode = symbolNode;
        this.callNodes = new ArrayList<FCallNode>();
        this.callNodes.add(callNode);
        this.accessorType = new AccessorType(callNode.getName());
        this.name = this.getName();
        this.fileName = callNode.getPosition().getFile();
    }

    private String getName() {
        return this.symbolNode.getName().charAt(0) == '@' ? this.symbolNode.getName().substring(1) : this.symbolNode.getName();
    }

    public String getAccessorTypeName() {
        return this.accessorType.getTypeName();
    }

    public String getAttrName() {
        return this.name;
    }

    public boolean isWriter() {
        return this.accessorType.isWriter();
    }

    public boolean isReader() {
        return this.accessorType.isReader();
    }

    public void addAccessorType(AttrAccessorNodeWrapper otherAccessorNode) {
        this.accessorType.addOtherType(otherAccessorNode.getAccessorTypeName());
        this.callNodes.addAll(otherAccessorNode.callNodes);
    }

    public Collection<FCallNode> getAccessorNodes() {
        return this.callNodes;
    }

    public String getFileName() {
        return this.fileName;
    }

    public SymbolNode getSymbolNode() {
        return this.symbolNode;
    }

    public boolean containsAccessor(AttrAccessorNodeWrapper otherAccessor) {
        return otherAccessor.getAttrName().equals(this.getAttrName()) && this.accessorType.contains(otherAccessor.accessorType);
    }

    @Override
    public Node getWrappedNode() {
        return this.callNodes.toArray(new Node[this.callNodes.size()])[0];
    }

    private static class AccessorType {
        private static final int TYPE_WRITER = 1;
        private static final int TYPE_READER = 2;
        private static final int TYPE_ACCESSOR = 3;
        private int type;

        public AccessorType(String typeName) {
            this.type = this.evaluateType(typeName);
        }

        private int evaluateType(String typeName) {
            if (typeName.equals(AttrAccessorNodeWrapper.ATTR_WRITER)) {
                return 1;
            }
            return typeName.equals(AttrAccessorNodeWrapper.ATTR_READER) ? 2 : 3;
        }

        public void addOtherType(String otherTypeName) {
            int otherType = this.evaluateType(otherTypeName);
            this.type |= otherType;
        }

        public String getTypeName() {
            return typeNames[this.type - 1];
        }

        public boolean isWriter() {
            return (this.type & 1) != 0;
        }

        public boolean isReader() {
            return (this.type & 2) != 0;
        }

        public boolean contains(AccessorType otherType) {
            int andResult = otherType.type & this.type;
            return andResult == otherType.type;
        }
    }
}

