/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.editprovider;

import org.eclipse.text.edits.TextEdit;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.rewriter.DefaultFormatHelper;
import org.jruby.ast.visitor.rewriter.FormatHelper;
import org.jruby.ast.visitor.rewriter.ReWriteVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.editprovider.IEditProvider;
import org.rubypeople.rdt.refactoring.util.FileHelper;
import org.rubypeople.rdt.refactoring.util.HsrFormatter;

public abstract class EditProvider
implements IEditProvider {
    protected boolean lastEditInGroup;
    protected boolean firstEditInGroup;
    private boolean doFormat;
    private boolean doTrim;

    public abstract TextEdit getEdit(String var1);

    protected abstract int getOffset(String var1);

    protected abstract Node getEditNode(int var1, String var2);

    public EditProvider(boolean doFormat, boolean doTrim) {
        this.doFormat = doFormat;
        this.doTrim = doTrim;
    }

    protected FormatHelper getFormatHelper() {
        return new DefaultFormatHelper();
    }

    protected String getFormatedNode(String document) {
        int offset = this.getOffset(document);
        Node insertNode = this.getEditNode(offset, document);
        String text = ReWriteVisitor.createCodeFromNode((Node)insertNode, (String)document, (FormatHelper)this.getFormatHelper());
        if (this.doFormat) {
            text = HsrFormatter.format(document, text, offset);
        }
        if (this.doTrim) {
            text = text.trim();
        }
        String lineDelimiter = FileHelper.getLineDelimiter(document);
        return text.replaceAll("\n", lineDelimiter);
    }

    protected void setFirstInGroup(boolean first) {
        this.firstEditInGroup = first;
    }

    protected void setLastInGroup(boolean last) {
        this.lastEditInGroup = last;
    }

    protected boolean isNextLineEmpty(int offset, String document) {
        String nextLine;
        if (document.length() <= offset + 1) {
            return false;
        }
        int firstNL = this.getNextNLPosition(offset, document);
        if (firstNL == -1) {
            return false;
        }
        int secondNL = this.getNextNLPosition(firstNL + 1, document);
        if (secondNL == -1) {
            secondNL = document.length() - 1;
        }
        return (nextLine = document.substring(firstNL + 1, secondNL)).trim().length() == 0;
    }

    private int getNextNLPosition(int offset, String document) {
        String lineDelimiter = FileHelper.getLineDelimiter(document);
        return document.indexOf(lineDelimiter, offset);
    }

    protected ISourcePosition getExtendedPosition(Node node) {
        if (node instanceof NewlineNode) {
            node = ((NewlineNode)node).getNextNode();
        }
        ISourcePosition extendedPosition = node.getPositionIncludingComments();
        for (Object currentChild : node.childNodes()) {
            extendedPosition = NodeFactory.unionPositions(extendedPosition, this.getExtendedPosition((Node)currentChild));
        }
        return extendedPosition;
    }
}

