/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.documentprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.StrNode;
import org.jruby.lexer.yacc.SyntaxException;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.StringDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentWithIncluding
extends StringDocumentProvider {
    protected final IDocumentProvider docProvider;

    public DocumentWithIncluding(IDocumentProvider docProvider) {
        super(docProvider.getActiveFileName(), docProvider.getActiveFileContent());
        this.docProvider = docProvider;
        this.searchForRelatedFiles();
    }

    private void searchForRelatedFiles() {
        ArrayList<String> candidates = new ArrayList<String>(this.docProvider.getFileNames());
        ArrayList<String> markedForRemoval = new ArrayList<String>();
        HashSet<String> includedFiles = this.findAllIncludedFiles();
        do {
            markedForRemoval.clear();
            for (String actFileName : candidates) {
                String fileName = this.getFileNameWithoutPath(actFileName);
                if (includedFiles.contains(fileName)) {
                    this.addAndRemove(markedForRemoval, actFileName, fileName);
                    continue;
                }
                for (FCallNode node : this.getRequires(actFileName)) {
                    if (!this.nodeRequiresMe(node) || this.getFileNames().contains(actFileName)) continue;
                    this.addAndRemove(markedForRemoval, actFileName, fileName);
                }
            }
            this.removeMarkedFromCandidates(markedForRemoval, candidates);
        } while (markedForRemoval.size() > 0);
    }

    private void addAndRemove(ArrayList<String> markedForRemoval, String actFileName, String fileName) {
        this.addFile(fileName, this.docProvider.getFileContent(actFileName));
        markedForRemoval.add(actFileName);
    }

    private String cutProjectPath(String fileName) {
        return fileName.substring(fileName.lastIndexOf(47) + 1);
    }

    private HashSet<String> findAllIncludedFiles() {
        HashSet<String> includedFiles = new HashSet<String>();
        ClassNodeProvider includedProvider = this.docProvider.getIncludedClassNodeProvider();
        for (ClassNodeWrapper classNode : includedProvider.getAllClassNodes()) {
            for (PartialClassNodeWrapper partialClassNode : classNode.getPartialClassNodes()) {
                String file = partialClassNode.getWrappedNode().getPosition().getFile();
                if (file.equals(this.docName)) continue;
                includedFiles.add(file);
            }
        }
        return includedFiles;
    }

    private String getFileNameWithoutPath(String actFileName) {
        if (actFileName.contains("/")) {
            return actFileName.substring(actFileName.lastIndexOf("/") + 1);
        }
        return actFileName;
    }

    private boolean nodeRequiresMe(FCallNode node) {
        return this.isStrNode(node) && this.fileIsInResultSet(this.getRequiredFilename(node));
    }

    private void removeMarkedFromCandidates(ArrayList<String> markedForRemoval, Collection<String> candidates) {
        for (String actName : markedForRemoval) {
            candidates.remove(actName);
        }
    }

    private String getRequiredFilename(FCallNode node) {
        return ((StrNode)node.getArgsNode().childNodes().iterator().next()).getValue().toString();
    }

    private Collection<FCallNode> getRequires(String fileName) {
        try {
            RootNode rootNode = this.docProvider.getRootNode(fileName);
            return NodeProvider.getLoadAndRequireNodes((Node)rootNode);
        }
        catch (SyntaxException syntaxException) {
            return new ArrayList<FCallNode>();
        }
    }

    private boolean fileIsInResultSet(String fileName) {
        String pathlessName = this.cutProjectPath(fileName);
        if (!pathlessName.matches(".*\\.rb$")) {
            pathlessName = String.valueOf(pathlessName) + ".rb";
        }
        if (fileName.equals(this.cutProjectPath(this.docName))) {
            return true;
        }
        for (String name : this.files.keySet()) {
            if (!this.cutProjectPath(name).equals(pathlessName)) continue;
            return true;
        }
        return false;
    }

    private boolean isStrNode(FCallNode node) {
        return node.getArgsNode().childNodes().iterator().next() instanceof StrNode;
    }
}

