/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.documentprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.refactoring.classnodeprovider.AllFilesClassNodeProvider;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.classnodeprovider.IncludedClassesProvider;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentProvider
implements IDocumentProvider {
    private Map<String, RootNode> cachedRootNodes = new LinkedHashMap<String, RootNode>();

    @Override
    public ClassNodeProvider getClassNodeProvider() {
        return new ClassNodeProvider(this);
    }

    @Override
    public ClassNodeProvider getProjectClassNodeProvider() {
        return new AllFilesClassNodeProvider(this);
    }

    @Override
    public ClassNodeProvider getIncludedClassNodeProvider() {
        return new IncludedClassesProvider(this);
    }

    @Override
    public RootNode getActiveFileRootNode() {
        return this.getRootNode(this.getActiveFileName());
    }

    @Override
    public Collection<Node> getAllNodes() {
        ArrayList<Node> allNodes = new ArrayList<Node>();
        for (String currentFileName : this.getFileNames()) {
            allNodes.addAll(this.getAllNodes(currentFileName));
        }
        return allNodes;
    }

    public Collection<Node> getAllNodes(String fileName) {
        return NodeProvider.getAllNodes((Node)this.getRootNode(fileName));
    }

    @Override
    public RootNode getRootNode(String fileName) {
        if (!this.cachedRootNodes.containsKey(fileName)) {
            this.cachedRootNodes.put(fileName, NodeProvider.getRootNode(fileName, this.getFileContent(fileName)));
        }
        return this.cachedRootNodes.get(fileName);
    }
}

