/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.splitlocal;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.inlinemethod.TargetClassFinder;
import org.rubypeople.rdt.refactoring.core.splitlocal.ILocalVarFinder;
import org.rubypeople.rdt.refactoring.core.splitlocal.LocalVarUsage;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVarFinder
implements ILocalVarFinder {
    private Node enclosingMethod;

    @Override
    public Collection<LocalVarUsage> findLocalUsages(IDocumentProvider doc, int caretPosition) {
        RootNode rootNode = doc.getActiveFileRootNode();
        INameNode selectedAssignment = this.findAssignment(doc, caretPosition, (Node)rootNode);
        if (selectedAssignment == null) {
            return null;
        }
        this.enclosingMethod = SelectionNodeProvider.getEnclosingScope((Node)rootNode, (Node)selectedAssignment);
        assert (this.enclosingMethod != null);
        return this.createLocalVariableUsages(this.gatherLocalAssignments(selectedAssignment));
    }

    private INameNode findAssignment(IDocumentProvider doc, int caretPosition, Node rootNode) {
        INameNode selectedAssignment = (INameNode)SelectionNodeProvider.getSelectedNodeOfType(rootNode, caretPosition, LocalAsgnNode.class, DAsgnNode.class);
        if (selectedAssignment == null) {
            LocalVarNode selectedLocalVar = (LocalVarNode)SelectionNodeProvider.getSelectedNodeOfType(rootNode, caretPosition, LocalVarNode.class);
            if (selectedLocalVar == null) {
                return null;
            }
            selectedAssignment = new TargetClassFinder().localAsgnFromLocalVar(selectedLocalVar, doc);
        }
        return selectedAssignment;
    }

    private ArrayList<LocalVarUsage> createLocalVariableUsages(ArrayList<AssignableNode> myAsgns) {
        ArrayList<LocalVarUsage> foundNodes = new ArrayList<LocalVarUsage>();
        AssignableNode[] assignments = myAsgns.toArray(new AssignableNode[myAsgns.size()]);
        int i = 0;
        while (i < assignments.length) {
            LocalVarUsage var = this.createLocalVarUsageFromNode(assignments, i);
            if (this.isLastAssignment(assignments, i)) {
                this.setPositionToScopeEnd(var);
            } else {
                this.setEndPositionBeforeNextNode(assignments, i, var);
            }
            foundNodes.add(var);
            ++i;
        }
        return foundNodes;
    }

    private void setEndPositionBeforeNextNode(AssignableNode[] assignments, int i, LocalVarUsage var) {
        var.setToPosition(assignments[i + 1].getPosition().getStartOffset() - 1);
    }

    private void setPositionToScopeEnd(LocalVarUsage var) {
        var.setToPosition(this.enclosingMethod.getPosition().getEndOffset());
    }

    private boolean isLastAssignment(AssignableNode[] assignments, int i) {
        return i >= assignments.length - 1;
    }

    private LocalVarUsage createLocalVarUsageFromNode(AssignableNode[] assignments, int i) {
        LocalVarUsage var = new LocalVarUsage();
        var.setFromPosition(assignments[i].getPosition().getStartOffset());
        var.setNode(assignments[i]);
        var.setName(((INameNode)assignments[i]).getName());
        return var;
    }

    private ArrayList<AssignableNode> gatherLocalAssignments(INameNode selectedNodeOfType) {
        ArrayList<AssignableNode> myAsgns = new ArrayList<AssignableNode>();
        Collection<LocalAsgnNode> allLocalAsgnNodes = NodeProvider.gatherLocalAsgnNodes(NodeUtil.getBody(this.enclosingMethod));
        for (LocalAsgnNode node : allLocalAsgnNodes) {
            if (!node.getName().equals(selectedNodeOfType.getName()) || this.nodeAssignsToItself((AssignableNode)node)) continue;
            myAsgns.add((AssignableNode)node);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (this.enclosingMethod instanceof IterNode) {
            nodes.addAll(NodeProvider.gatherNodesOfTypeInAktScopeNode(((IterNode)this.enclosingMethod).getVarNode(), DAsgnNode.class));
        }
        nodes.addAll(NodeProvider.gatherNodesOfTypeInAktScopeNode(NodeUtil.getBody(this.enclosingMethod), DAsgnNode.class));
        for (Node node : nodes) {
            if (!((DAsgnNode)node).getName().equals(selectedNodeOfType.getName()) || this.nodeAssignsToItself((AssignableNode)((DAsgnNode)node))) continue;
            myAsgns.add((AssignableNode)((DAsgnNode)node));
        }
        return myAsgns;
    }

    private boolean nodeAssignsToItself(AssignableNode node) {
        Collection<Node> allNodes = NodeProvider.getAllNodes((Node)node);
        for (Node child : allNodes) {
            LocalAsgnNode localAsgnNode;
            LocalVarNode localVarNode;
            if (child instanceof LocalVarNode && node instanceof LocalAsgnNode) {
                localVarNode = (LocalVarNode)child;
                localAsgnNode = (LocalAsgnNode)node;
                if (localAsgnNode.getIndex() != localVarNode.getIndex()) continue;
                return true;
            }
            if (!(child instanceof DVarNode) || !(node instanceof DAsgnNode)) continue;
            localVarNode = (DVarNode)child;
            localAsgnNode = (DAsgnNode)node;
            if (!localAsgnNode.getName().equals(localVarNode.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Node getScopeNode() {
        return this.enclosingMethod;
    }
}

