/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamemodule;

import java.util.ArrayList;
import org.rubypeople.rdt.refactoring.core.ConstNameValidator;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.RubyRefactoring;
import org.rubypeople.rdt.refactoring.core.renamemodule.RenameModuleConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamemodule.RenameModuleConfig;
import org.rubypeople.rdt.refactoring.core.renamemodule.RenameModuleEditProvider;
import org.rubypeople.rdt.refactoring.ui.NewNameListener;
import org.rubypeople.rdt.refactoring.ui.pages.OccurenceReplaceSelectionPage;
import org.rubypeople.rdt.refactoring.ui.pages.RenamePage;

public class RenameModuleRefactoring
extends RubyRefactoring {
    public static final String NAME = "Rename Module";

    public RenameModuleRefactoring(IRefactoringContext selectionProvider) {
        super(NAME, selectionProvider);
        RenameModuleConfig renameModuleConfig = new RenameModuleConfig(this.getDocumentProvider(), selectionProvider.getCaretPosition());
        RenameModuleConditionChecker conditionChecker = new RenameModuleConditionChecker(renameModuleConfig);
        this.setRefactoringConditionChecker(conditionChecker);
        if (conditionChecker.shouldPerform()) {
            RenameModuleEditProvider editProvider = new RenameModuleEditProvider(renameModuleConfig);
            this.setEditProvider(editProvider);
            this.pages.add(new RenamePage(NAME, renameModuleConfig.getOriginalName(), new NewNameListener(renameModuleConfig, new ConstNameValidator(), new ArrayList<String>())));
            if (!renameModuleConfig.getPossibleCalls().isEmpty()) {
                this.pages.add(new OccurenceReplaceSelectionPage(renameModuleConfig, renameModuleConfig.getDocumentProvider()));
            }
        }
    }
}

