/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamemodule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jruby.ast.ClassNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.ModuleNodeProvider;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamemodule.ModuleIncludeFinder;
import org.rubypeople.rdt.refactoring.core.renamemodule.ModuleSpecifierWrapper;
import org.rubypeople.rdt.refactoring.core.renamemodule.RenameModuleConfig;
import org.rubypeople.rdt.refactoring.nodewrapper.ModuleNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NameHelper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameModuleConditionChecker
extends RefactoringConditionChecker {
    public static final String DEFAULT_ERROR = "Please select the name of a module definition.";
    private RenameModuleConfig config;

    public RenameModuleConditionChecker(IRefactoringConfig config) {
        super(config);
    }

    @Override
    protected void checkInitialConditions() {
        if (this.config.getSelectedModule() == null) {
            this.addError(DEFAULT_ERROR);
        }
    }

    @Override
    protected void checkFinalConditions() {
        if (this.config.getOriginalName().equals(this.config.getNewName())) {
            this.addWarning("You did not change the name.");
        }
        if (this.config.getAllModuleNames().contains(this.config.getNewName())) {
            this.addWarning("The name you chose is already in use.");
        }
    }

    @Override
    public void init(IRefactoringConfig configObj) {
        this.config = (RenameModuleConfig)configObj;
        ModuleNodeWrapper selectedModule = ModuleNodeProvider.getSelectedModuleNode((Node)this.config.getDocumentProvider().getActiveFileRootNode(), this.config.getCarretPosition());
        if (selectedModule == null || this.caretIsNotOnModuleName(selectedModule)) {
            return;
        }
        this.config.setSelectedModule(selectedModule);
        this.config.setNewName(this.config.getOriginalName());
        this.config.setModuleParts(ModuleNodeProvider.findOtherParts(this.config.getDocumentProvider(), this.config.getSelectedModule()));
        this.config.setIncludes(new ModuleIncludeFinder(this.config.getDocumentProvider()).find(this.config.getOriginalFullName()));
        this.config.setPossibleCalls(this.findPossibleCalls());
        this.config.setSelectedCalls(this.config.getPossibleCalls());
        this.config.setAllModuleNames(this.getAllModuleNames());
    }

    private Collection<String> getAllModuleNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ModuleNodeWrapper module : ModuleNodeProvider.findAllModules(this.config.getDocumentProvider())) {
            names.add(module.getFullName());
        }
        return names;
    }

    private ArrayList<ModuleSpecifierWrapper> findPossibleCalls() {
        ArrayList<ModuleSpecifierWrapper> calls = new ArrayList<ModuleSpecifierWrapper>();
        Collection<Node> toSkip = this.collectAllModulePartsAndIncludeNameNodes();
        for (String file : this.config.getDocumentProvider().getFileNames()) {
            RootNode rootNode = this.config.getDocumentProvider().getRootNode(file);
            for (Node node : NodeProvider.getSubNodes((Node)rootNode, ConstNode.class, Colon2Node.class)) {
                ModuleSpecifierWrapper module;
                if (toSkip.contains(node) || NodeProvider.findParentNode((Node)rootNode, node) instanceof ClassNode || NodeProvider.findParentNode((Node)rootNode, node) instanceof SClassNode || !(module = ModuleSpecifierWrapper.create(node, NameHelper.getEncosingModulePrefix((Node)rootNode, node))).getFullName().equals(this.config.getOriginalFullName())) continue;
                calls.add(module);
            }
        }
        return calls;
    }

    private Collection<Node> collectAllModulePartsAndIncludeNameNodes() {
        HashSet<Node> toSkip = new HashSet<Node>();
        for (ModuleNodeWrapper part : this.config.getModuleParts()) {
            toSkip.add((Node)part.getWrappedNode().getCPath());
        }
        for (ModuleSpecifierWrapper include : this.config.getIncludes()) {
            toSkip.add(include.getWrappedNode());
        }
        return toSkip;
    }

    private boolean caretIsNotOnModuleName(ModuleNodeWrapper selectedModule) {
        return !NodeUtil.positionIsInNode(this.config.getCarretPosition(), selectedModule.getWrappedNode().getCPath());
    }
}

