/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamemodule;

import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.INodeWrapper;
import org.rubypeople.rdt.refactoring.util.NameHelper;

public abstract class ModuleSpecifierWrapper
implements INodeWrapper {
    protected String modulePrefix;

    public static ModuleSpecifierWrapper create(Node node, String modulePrefix) {
        if (node instanceof Colon2Node) {
            return new Colon2IncludeWrapper((Colon2Node)node, modulePrefix);
        }
        return new ConstIncludeWrapper((ConstNode)node, modulePrefix);
    }

    public abstract Node getWrappedNode();

    public abstract String getIncludeName();

    public String getFullName() {
        if ("".equals(this.modulePrefix)) {
            return this.getIncludeName();
        }
        return String.valueOf(this.modulePrefix) + "::" + this.getIncludeName();
    }

    public abstract void setNewName(String var1, String var2);

    private static class Colon2IncludeWrapper
    extends ModuleSpecifierWrapper {
        protected Colon2Node node;

        public Colon2IncludeWrapper(Colon2Node node, String modulePrefix) {
            this.node = node;
            this.modulePrefix = modulePrefix;
        }

        public String getIncludeName() {
            return NameHelper.getFullyQualifiedName((Node)this.node);
        }

        public Node getWrappedNode() {
            return this.node;
        }

        public void setNewName(String oldName, String newName) {
            for (Node node : NodeProvider.getSubNodes((Node)this.node, Colon2Node.class, ConstNode.class)) {
                INameNode nameNode = (INameNode)node;
                if (!nameNode.getName().equals(oldName)) continue;
                if (node instanceof Colon2Node) {
                    ((Colon2Node)node).setName(newName);
                    return;
                }
                ((ConstNode)node).setName(newName);
                return;
            }
        }
    }

    private static class ConstIncludeWrapper
    extends ModuleSpecifierWrapper {
        protected ConstNode node;

        public ConstIncludeWrapper(ConstNode node, String modulePrefix) {
            this.node = node;
            this.modulePrefix = modulePrefix;
        }

        public String getIncludeName() {
            return this.node.getName();
        }

        public Node getWrappedNode() {
            return this.node;
        }

        public void setNewName(String oldName, String newName) {
            this.node.setName(newName);
        }
    }
}

