/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamemethod.methoditems;

import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.renamemethod.methoditems.MethodItem;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;

public class CallCandidateItem
extends MethodItem {
    private MethodCallNodeWrapper itemDecorator;

    public CallCandidateItem(MethodCallNodeWrapper currentCandidate) {
        this.itemDecorator = currentCandidate;
    }

    public String getMethodPartName() {
        return this.itemDecorator.getName();
    }

    public Node getMethodPartNode() {
        return this.itemDecorator.getWrappedNode();
    }

    public Node getRenamedPartNode(String newName) {
        return this.getReamedNode(newName);
    }

    public Node getReamedNode(String newName) {
        int type = this.itemDecorator.getType();
        if (type == 1) {
            return this.getRenamedCallNode(newName);
        }
        if (type == 2) {
            return this.getRenamedVCallNode(newName);
        }
        if (type == 3) {
            return this.getRenamedFCallNode(newName);
        }
        return null;
    }

    private Node getRenamedFCallNode(String newName) {
        Node arguments = ((FCallNode)this.itemDecorator.getWrappedNode()).getArgsNode();
        return NodeFactory.createFCallNode(newName, arguments);
    }

    private Node getRenamedVCallNode(String newName) {
        return NodeFactory.createVCallNode(newName);
    }

    private Node getRenamedCallNode(String newName) {
        return NodeFactory.createCallNode(this.itemDecorator.getReceiverNode(), newName, this.itemDecorator.getArgsNode());
    }
}

