/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamelocal;

import java.util.Observable;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.rubypeople.rdt.refactoring.core.renamelocal.Messages;
import org.rubypeople.rdt.refactoring.ui.IErrorMessageGenerator;
import org.rubypeople.rdt.refactoring.ui.IErrorMessageReceiver;
import org.rubypeople.rdt.refactoring.util.NameValidator;

public class VariableNameProvider
extends Observable
implements IErrorMessageGenerator {
    private String selected = "";
    private String name = "";
    private IErrorMessageReceiver errorReceiver;

    public VariableNameProvider(String selected) {
        this.selected = selected;
        this.name = selected;
    }

    public String getSelected() {
        return this.selected;
    }

    public String getName() {
        return this.name;
    }

    public void handleEvent(Event event) {
        if (event.widget instanceof List) {
            this.selected = ((List)event.widget).getSelection()[0];
        } else if (event.widget instanceof Text) {
            String newName = ((Text)event.widget).getText();
            if (NameValidator.isValidLocalVariableName(newName)) {
                this.name = newName;
                this.errorReceiver.setError(null);
            } else {
                this.errorReceiver.setError(String.valueOf(newName) + Messages.VariableNameProvider_NoValidName);
            }
        } else {
            return;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void setErrorReceiver(IErrorMessageReceiver errorReceiver) {
        this.errorReceiver = errorReceiver;
    }
}

