/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamelocal;

import java.util.Collection;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.types.INameNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.renamelocal.Messages;
import org.rubypeople.rdt.refactoring.core.renamelocal.RenameLocalConfig;
import org.rubypeople.rdt.refactoring.core.renamelocal.RenameLocalEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.LocalNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NameValidator;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class RenameLocalConditionChecker
extends RefactoringConditionChecker {
    private static final String ALREADY_EXISTS = Messages.RenameLocalConditionChecker_NameAlreadyExists;
    private static final String INVALID_NAME = Messages.RenameLocalConditionChecker_NameInvalid;
    private static final String NO_VARIABLE_SELECTED = Messages.RenameLocalConditionChecker_NoSelection;
    private static final String NO_LOCAL_VARIABLES = Messages.RenameLocalConditionChecker_NoLocalVariable;
    private static final Class[] SELECTED_NODE_TYPES = new Class[]{LocalVarNode.class, LocalAsgnNode.class, ArgumentNode.class, BlockArgNode.class, DVarNode.class, DAsgnNode.class};
    public static final String DEFAULT_ERROR = NO_LOCAL_VARIABLES;
    private RenameLocalConfig config;

    public RenameLocalConditionChecker(RenameLocalConfig config) {
        super(config);
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (RenameLocalConfig)configObj;
        RootNode rootNode = this.config.getDocumentProvider().getActiveFileRootNode();
        Node selectedNode = SelectionNodeProvider.getSelectedNodeOfType((Node)rootNode, this.config.getCaretPosition(), SELECTED_NODE_TYPES);
        if (selectedNode instanceof AssignableNode) {
            int start = selectedNode.getPosition().getStartOffset();
            int end = start + ((INameNode)selectedNode).getName().length();
            if (this.config.getCaretPosition() < start || this.config.getCaretPosition() > end) {
                return;
            }
        }
        this.config.setSelectedNode(selectedNode);
        if (selectedNode == null) {
            Collection<MethodDefNode> methodNodes = NodeProvider.getMethodNodes((Node)rootNode);
            this.config.setSelectedMethod(SelectionNodeProvider.getSelectedNodeOfType(methodNodes, this.config.getCaretPosition(), MethodDefNode.class));
        } else {
            this.config.setSelectedMethod(SelectionNodeProvider.getEnclosingScope((Node)rootNode, selectedNode));
        }
        if (this.config.getSelectedMethod() != null) {
            this.config.setLocalNames(NodeUtil.getScope(this.config.getSelectedMethod()).getVariables());
        }
    }

    protected void checkInitialConditions() {
        if (!(this.config.hasSelectedNode() && this.isSelectedNodeLocalVar() || this.isSelectionInMethodDefinition())) {
            this.addError(NO_LOCAL_VARIABLES);
        }
    }

    private boolean isSelectionInMethodDefinition() {
        if (this.config.getSelectedMethod() == null) {
            return false;
        }
        ISourcePosition position = ((MethodDefNode)this.config.getSelectedMethod()).getArgsNode().getPosition();
        return position.getStartOffset() <= this.config.getCaretPosition() && position.getEndOffset() >= this.config.getCaretPosition();
    }

    private boolean isSelectedNodeLocalVar() {
        Node selected = this.config.getSelectedNode();
        if (NodeUtil.nodeAssignableFrom(selected, LocalNodeWrapper.LOCAL_NODES_CLASSES)) {
            return true;
        }
        if (NodeUtil.nodeAssignableFrom(selected, ArgumentNode.class, BlockArgNode.class) && NodeUtil.nodeAssignableFrom(this.config.getSelectedMethod(), MethodDefNode.class)) {
            MethodDefNode methodNode = (MethodDefNode)this.config.getSelectedMethod();
            return methodNode.getNameNode() != selected;
        }
        return false;
    }

    protected void checkFinalConditions() {
        RenameLocalEditProvider editProvider = this.config.getRenameEditProvider();
        if (editProvider.getSelectedVariableName().equals("") && editProvider.getNewVariableName().equals("")) {
            this.addError(NO_VARIABLE_SELECTED);
        }
        if (!NameValidator.isValidLocalVariableName(editProvider.getNewVariableName())) {
            this.addError(INVALID_NAME);
        }
        if (editProvider.getSelectedVariableName().equals(editProvider.getNewVariableName())) {
            this.addError(Messages.RenameLocalConditionChecker_SameName);
        }
        String[] stringArray = this.config.getLocalNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (editProvider.getNewVariableName().equals(s)) {
                this.addError(ALREADY_EXISTS);
            }
            ++n2;
        }
    }
}

