/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamefield;

import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.IValidator;
import org.rubypeople.rdt.refactoring.core.RubyRefactoring;
import org.rubypeople.rdt.refactoring.core.renamefield.FieldRenamer;
import org.rubypeople.rdt.refactoring.core.renamefield.Messages;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldConditionChecker;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldConfig;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentWithIncluding;
import org.rubypeople.rdt.refactoring.ui.NewNameListener;
import org.rubypeople.rdt.refactoring.ui.pages.OccurenceReplaceSelectionPage;
import org.rubypeople.rdt.refactoring.ui.pages.RenameFieldPage;
import org.rubypeople.rdt.refactoring.util.NameValidator;

public class RenameFieldRefactoring
extends RubyRefactoring {
    public static final String NAME = Messages.RenameFieldRefactoring_Name;
    private RenameFieldConfig config;
    private RenameFieldConditionChecker checker;
    private FieldRenamer renamer;
    private NewNameListener nameListener;
    private RenameFieldPage pageOne;
    private OccurenceReplaceSelectionPage page;

    public RenameFieldRefactoring(IRefactoringContext selectionProvider) {
        super(NAME, selectionProvider);
        this.config = new RenameFieldConfig(new DocumentWithIncluding(this.getDocumentProvider()), selectionProvider.getCaretPosition());
        this.checker = new RenameFieldConditionChecker(this.config);
        this.setRefactoringConditionChecker(this.checker);
        if (this.checker.shouldPerform()) {
            this.renamer = new FieldRenamer(this.config);
            this.setEditProvider(this.renamer);
            this.nameListener = new NewNameListener(this.config, new LocalVarNameValidator(), this.config.getFieldNames());
            this.pageOne = new RenameFieldPage(this.config.getSelectedName().replaceAll("@", ""), this.nameListener, this.config);
            this.pages.add(this.pageOne);
            this.page = new OccurenceReplaceSelectionPage(this.config, this.config.getDocumentProvider());
            this.pages.add(this.page);
        }
    }

    private static final class LocalVarNameValidator
    implements IValidator {
        private LocalVarNameValidator() {
        }

        public boolean isValid(String test) {
            return NameValidator.isValidLocalVariableName(test);
        }
    }
}

