/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renamefield;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.refactoring.classnodeprovider.IncludedClassesProvider;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.renamefield.FieldProvider;
import org.rubypeople.rdt.refactoring.core.renamefield.InstVarAccessesFinder;
import org.rubypeople.rdt.refactoring.core.renamefield.Messages;
import org.rubypeople.rdt.refactoring.core.renamefield.RenameFieldConfig;
import org.rubypeople.rdt.refactoring.core.renamefield.fielditems.FieldItem;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentWithIncluding;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

public class RenameFieldConditionChecker
extends RefactoringConditionChecker {
    public static final String DEFAULT_ERROR = Messages.RenameFieldConditionChecker_NoFieldAtCaretPosition;
    private RenameFieldConfig config;
    private RootNode rootNode;

    public RenameFieldConditionChecker(RenameFieldConfig config) {
        super(config);
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (RenameFieldConfig)configObj;
        this.config.setDocProvider(new DocumentWithIncluding(this.config.getDocumentProvider()));
        this.rootNode = this.config.getDocumentProvider().getActiveFileRootNode();
        try {
            ClassNodeWrapper enclosingClassNode = SelectionNodeProvider.getSelectedClassNode((Node)this.rootNode, this.config.getCaretPosition());
            IncludedClassesProvider classNodeProvider = new IncludedClassesProvider(this.config.getDocumentProvider());
            this.config.setWholeClassNode(classNodeProvider.getClassNode(enclosingClassNode.getName()));
            this.config.setFieldProvider(new FieldProvider(this.config.getWholeClassNode(), this.config.getDocumentProvider()));
            this.config.setSelectedItem(this.config.getFieldProvider().getNameAtPosition(this.config.getCaretPosition(), this.config.getDocumentProvider().getActiveFileName()));
            if (this.config.hasSelectedItem()) {
                this.config.setSelectedName(this.config.getSelectedItem().getFieldName());
            }
        }
        catch (NoClassNodeException noClassNodeException) {}
        if (this.config.hasSelectedName()) {
            this.setSelection();
        }
    }

    private void setSelection() {
        String fieldName = this.config.getSelectedName();
        boolean concernsClassField = this.config.concernsClassField();
        ArrayList<FieldItem> selectedItems = this.config.getFieldProvider().getFieldItems(fieldName, concernsClassField);
        this.config.setSelectedCalls(selectedItems);
        ArrayList<FieldItem> possibleItems = new ArrayList<FieldItem>();
        possibleItems.addAll(selectedItems);
        if (!concernsClassField) {
            possibleItems.addAll(InstVarAccessesFinder.find(this.config.getDocumentProvider(), this.config.getSelectedName()));
        }
        this.config.setPossibleCalls(possibleItems);
    }

    protected void checkFinalConditions() {
        String newName = this.config.getNewName();
        String selectedName = this.config.getSelectedName();
        if (newName == null || selectedName.equals(newName)) {
            this.addError(Messages.RenameFieldConditionChecker_NoNewName);
            return;
        }
        for (String currentName : this.config.getFieldNames()) {
            if (!currentName.equals(newName)) continue;
            this.addError(Messages.RenameFieldConditionChecker_AlreadyExists);
            return;
        }
    }

    protected void checkInitialConditions() {
        Collection<FieldNodeWrapper> fields = PartialClassNodeWrapper.getFieldsFromNode((Node)this.config.getDocumentProvider().getActiveFileRootNode());
        FieldNodeWrapper selectedFieldNode = SelectionNodeProvider.getSelectedWrappedNode(fields, this.config.getCaretPosition());
        if (this.config.getWholeClassNode() == null && selectedFieldNode != null) {
            this.addError(Messages.RenameFieldConditionChecker_CannotNoSurroundingClass);
            return;
        }
        if (!this.config.hasSelectedName() || !this.isSelectionInFieldName(selectedFieldNode)) {
            this.addError(DEFAULT_ERROR);
        }
    }

    private boolean isSelectionInFieldName(FieldNodeWrapper node) {
        return this.config.getCaretPosition() <= node.getPosition().getStartOffset() + node.getName().length();
    }
}

