/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renameclass;

import java.util.Collection;
import org.jruby.ast.ClassNode;
import org.rubypeople.rdt.refactoring.core.renameclass.ChildClassesRenameEditProvider;
import org.rubypeople.rdt.refactoring.core.renameclass.ClassFinder;
import org.rubypeople.rdt.refactoring.core.renameclass.ClassInstanciationFinder;
import org.rubypeople.rdt.refactoring.core.renameclass.ConstructorCall;
import org.rubypeople.rdt.refactoring.core.renameclass.ConstructorRenameEditProvider;
import org.rubypeople.rdt.refactoring.core.renameclass.RenameClassConfig;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.editprovider.FileMultiEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.IMultiFileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.MultiFileEditProvider;
import org.rubypeople.rdt.refactoring.editprovider.ScopingNodeRenameEditProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameClassEditProvider
implements IMultiFileEditProvider {
    private final RenameClassConfig config;
    private IDocumentProvider document;

    public RenameClassEditProvider(RenameClassConfig config) {
        this.config = config;
        this.document = config.getDocumentWithIncludingProvider();
    }

    private ChildClassesRenameEditProvider createChildrenEditProvider() {
        Collection<ClassNode> childClasses = new ClassFinder(this.document, this.config.getSelectedNode().getCPath().getName(), this.config.getModulePrefix()).findChildren();
        return new ChildClassesRenameEditProvider(childClasses, this.config.getNewName());
    }

    private ScopingNodeRenameEditProvider createPartialsEditProvider() {
        Collection<ClassNode> classNodes = new ClassFinder(this.document, this.config.getSelectedNode().getCPath().getName(), this.config.getModulePrefix()).findParts();
        return new ScopingNodeRenameEditProvider(classNodes, this.config.getNewName());
    }

    private ConstructorRenameEditProvider createConstructorEditProvider() {
        Collection<ConstructorCall> allCalls = new ClassInstanciationFinder().findAll(this.document, this.config.getSelectedNode().getCPath().getName(), this.config.getModulePrefix());
        return new ConstructorRenameEditProvider(allCalls, this.config.getNewName());
    }

    @Override
    public Collection<FileMultiEditProvider> getFileEditProviders() {
        MultiFileEditProvider fileEdits = new MultiFileEditProvider();
        fileEdits.addEditProviders(this.createConstructorEditProvider().getEditProviders());
        fileEdits.addEditProviders(this.createPartialsEditProvider().getEditProviders());
        fileEdits.addEditProviders(this.createChildrenEditProvider().getEditProviders());
        return fileEdits.getFileEditProviders();
    }
}

