/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.renameclass;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.CallNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.renameclass.ConstructorCall;
import org.rubypeople.rdt.refactoring.core.renameclass.IClassInstanciationFinder;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.StringDocumentProvider;
import org.rubypeople.rdt.refactoring.util.NameHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInstanciationFinder
implements IClassInstanciationFinder {
    private String modulePrefix;

    @Override
    public Collection<ConstructorCall> findAll(IDocumentProvider doc, String name, String modulePrefix) {
        this.modulePrefix = modulePrefix;
        ArrayList<ConstructorCall> found = new ArrayList<ConstructorCall>();
        for (String fileName : doc.getFileNames()) {
            if (fileName.equals(doc.getActiveFileName())) continue;
            this.addIfCreatesInstance(name, found, new StringDocumentProvider(fileName, doc.getFileContent(fileName)));
        }
        this.addIfCreatesInstance(name, found, new StringDocumentProvider(doc.getActiveFileName(), doc.getActiveFileContent()));
        return found;
    }

    private void addIfCreatesInstance(String name, Collection<ConstructorCall> found, DocumentProvider file) {
        for (Node node : NodeProvider.getSubNodes((Node)file.getActiveFileRootNode(), CallNode.class)) {
            CallNode call = (CallNode)node;
            if (!this.isConstructorFor(name, call)) continue;
            found.add(new ConstructorCall(call));
        }
    }

    private boolean isConstructorFor(String name, CallNode call) {
        return this.isCallToNew(call) && (this.isNotInModule() && this.createsAnInstance(name, call) || this.createsAnInstanceWithFullModulePath(name, call));
    }

    private boolean isCallToNew(CallNode call) {
        return call.getName().equals("new");
    }

    private boolean createsAnInstanceWithFullModulePath(String name, CallNode call) {
        return call.getReceiverNode() instanceof Colon2Node && NameHelper.getFullyQualifiedName(call.getReceiverNode()).equals(String.valueOf(this.modulePrefix) + name);
    }

    private boolean isNotInModule() {
        return this.modulePrefix == null || "".equals(this.modulePrefix);
    }

    private boolean createsAnInstance(String name, CallNode call) {
        return call.getReceiverNode() instanceof ConstNode && ((ConstNode)call.getReceiverNode()).getName().equals(name);
    }
}

